// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)
    based on code by Marc Shapiro (shapiro@sor.inria.fr)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _LPmsgptrXPQueue_h
#pragma once
#define _LPmsgptrXPQueue_h

#include "LPmsgptr.XPlex.h"
#include "LPmsgptr.Queue.h"

class LPmsgptrXPQueue : public LPmsgptrQueue
{
protected:
  LPmsgptrXPlex     p;

public:
               LPmsgptrXPQueue(int chunksize = DEFAULT_INITIAL_CAPACITY);
               LPmsgptrXPQueue(const LPmsgptrXPQueue& q);
               ~LPmsgptrXPQueue();

  void          operator = (const LPmsgptrXPQueue&);

  void          enq(LPmsgptr  item);
  LPmsgptr           deq();
  LPmsgptr&          front();
  void          del_front();

  void          clear();
  int           empty();
  int           full();
  int           length();
               
  int           OK();
};

inline LPmsgptrXPQueue::LPmsgptrXPQueue(int chunksize = DEFAULT_INITIAL_CAPACITY) 
     : p(chunksize) {}
inline LPmsgptrXPQueue::LPmsgptrXPQueue(const LPmsgptrXPQueue& q) : p(q.p) {}

inline LPmsgptrXPQueue::~LPmsgptrXPQueue() {}

inline void LPmsgptrXPQueue::enq(LPmsgptr item)
{
  p.add_high(item);
}

inline LPmsgptr LPmsgptrXPQueue::deq()
{
  LPmsgptr res = p.low_element();
  p.del_low();
  return res;
}

inline LPmsgptr& LPmsgptrXPQueue::front()
{
  return p.low_element();
}


inline void LPmsgptrXPQueue::del_front()
{
  p.del_low();
}

inline void LPmsgptrXPQueue::operator =(const LPmsgptrXPQueue& s)
{
  p.operator = (s.p);
}

inline int LPmsgptrXPQueue::empty()
{
  return p.empty();
}

inline int LPmsgptrXPQueue::full()
{
  return p.full();
}

inline int LPmsgptrXPQueue::length()
{
  return p.length();
}

inline int LPmsgptrXPQueue::OK()
{
  return p.OK();
}

inline void LPmsgptrXPQueue::clear()
{
  p.clear();
}

#endif
