// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)
    based on code by Marc Shapiro (shapiro@sor.inria.fr)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

#ifndef _LPmsgptrXPlex_h
#ifdef __GNUG__
#pragma once
#pragma interface
#endif
#define _LPmsgptrXPlex_h 1

#include "LPmsgptr.Plex.h"

class LPmsgptrXPlex: public LPmsgptrPlex
{
  LPmsgptrIChunk*       ch;           // cached chunk

  void             make_initial_chunks(int up = 1);

  void             cache(int idx) const;
  void             cache(const LPmsgptr* p) const;

  LPmsgptr*             dopred(const LPmsgptr* p) const;
  LPmsgptr*             dosucc(const LPmsgptr* p) const;

  void             set_cache(const LPmsgptrIChunk* t) const; // logically, 
                                               // not physically const
public:
                   LPmsgptrXPlex();                 // set low = 0;
                                               // fence = 0;
                                               // csize = default

                   LPmsgptrXPlex(int ch_size);      // low = 0; 
                                               // fence = 0;
                                               // csize = ch_size

                   LPmsgptrXPlex(int lo,            // low = lo; 
                            int ch_size);      // fence=lo
                                               // csize = ch_size

                   LPmsgptrXPlex(int lo,            // low = lo
                            int hi,            // fence = hi+1
                            const LPmsgptr  initval,// fill with initval,
                            int ch_size = 0);  // csize= ch_size
                                               // or fence-lo if 0

                   LPmsgptrXPlex(const LPmsgptrXPlex&);
  
  void             operator= (const LPmsgptrXPlex&);

// virtuals


  LPmsgptr&             high_element ();
  LPmsgptr&             low_element ();

  const LPmsgptr&       high_element () const;
  const LPmsgptr&       low_element () const;

  Pix              first() const;
  Pix              last() const;
  void             prev(Pix& ptr) const;
  void             next(Pix& ptr) const;
  int              owns(Pix p) const;
  LPmsgptr&             operator () (Pix p);
  const LPmsgptr&       operator () (Pix p) const;

  int              low() const; 
  int              high() const;
  int              valid(int idx) const;
  void             prev(int& idx) const;
  void             next(int& x) const;
  LPmsgptr&             operator [] (int index);
  const LPmsgptr&       operator [] (int index) const;
    
  int              Pix_to_index(Pix p) const;
  Pix              index_to_Pix(int idx) const;    

  int              can_add_high() const;
  int              can_add_low() const;
  int              full() const;

  int              add_high(const LPmsgptr  elem);
  int              del_high ();
  int              add_low (const LPmsgptr  elem);
  int              del_low ();

  void             fill(const LPmsgptr  x);
  void             fill(const LPmsgptr  x, int from, int to);
  void             clear();
  void             reverse();
  void             append(const LPmsgptrXPlex& a); 
  void             prepend(const LPmsgptrXPlex& a);
    
  int              OK () const; 

};

#if defined(__OPTIMIZE__) || defined(USE_LIBGXX_INLINES)

inline void LPmsgptrXPlex::prev(int& idx) const
{
  --idx;
}

inline void LPmsgptrXPlex::next(int& idx) const
{
  ++idx;
}

inline  int LPmsgptrXPlex::full () const
{
  return 0;
}

inline int LPmsgptrXPlex::can_add_high() const
{
  return 1;
}

inline int LPmsgptrXPlex::can_add_low() const
{
  return 1;
}

inline  int LPmsgptrXPlex::valid (int idx) const
{
  return idx >= lo && idx < fnc;
}

inline int LPmsgptrXPlex::low() const
{
  return lo;
}

inline int LPmsgptrXPlex::high() const
{
  return fnc - 1;
}

inline LPmsgptr& LPmsgptrXPlex:: operator [] (int idx)
{
  if (!ch->actual_index(idx)) cache(idx);
  return *(ch->pointer_to(idx));
}

inline const LPmsgptr& LPmsgptrXPlex:: operator [] (int idx) const
{
  if (!ch->actual_index(idx)) cache(idx);
  return *((const LPmsgptr*)(ch->pointer_to(idx)));
}

inline  LPmsgptr& LPmsgptrXPlex::low_element ()
{
  if (empty()) index_error();
  return *(hd->pointer_to(lo));
}

inline  const LPmsgptr& LPmsgptrXPlex::low_element () const
{
  if (empty()) index_error();
  return *((const LPmsgptr*)(hd->pointer_to(lo)));
}

inline  LPmsgptr& LPmsgptrXPlex::high_element ()
{
  if (empty()) index_error();
  return *(tl()->pointer_to(fnc - 1));
}

inline const LPmsgptr& LPmsgptrXPlex::high_element () const
{
  if (empty()) index_error();
  return *((const LPmsgptr*)(tl()->pointer_to(fnc - 1)));
}

inline  int LPmsgptrXPlex::Pix_to_index(Pix px) const
{
  LPmsgptr* p = (LPmsgptr*)px;
  if (!ch->actual_pointer(p)) cache(p);
  return ch->index_of(p);
}

inline  Pix LPmsgptrXPlex::index_to_Pix(int idx) const
{
  if (!ch->actual_index(idx)) cache(idx);
  return (Pix)(ch->pointer_to(idx));
}

inline Pix LPmsgptrXPlex::first() const
{
  return Pix(hd->LPmsgptrIChunk::first_pointer());
}

inline Pix LPmsgptrXPlex::last() const
{
  return Pix(tl()->LPmsgptrIChunk::last_pointer());
}

inline void LPmsgptrXPlex::prev(Pix& p) const
{
  Pix q = Pix(ch->LPmsgptrIChunk::pred((LPmsgptr*) p));
  p = (q == 0)? Pix(dopred((const LPmsgptr*) p)) : q;
}

inline void LPmsgptrXPlex::next(Pix& p) const
{
  Pix q = Pix(ch->LPmsgptrIChunk::succ((LPmsgptr*) p));
  p = (q == 0)? Pix(dosucc((const LPmsgptr*)p)) : q;
}

inline LPmsgptr& LPmsgptrXPlex:: operator () (Pix p)
{
  return *((LPmsgptr*)p);
}

inline const LPmsgptr& LPmsgptrXPlex:: operator () (Pix p) const
{
  return *((const LPmsgptr*)p);
}

inline void LPmsgptrXPlex::set_cache(const LPmsgptrIChunk* t) const
{
  ((LPmsgptrXPlex*)(this))->ch = (LPmsgptrIChunk*)t;
}

#endif
#endif
