#include <stream.h>
#include "LPseq.h"
#include "LPmux.h"
#include <assert.h>

static ClassId ThisClassId = "LPseq";

ClassId
LPseq::classId()
{
    return( ThisClassId );
}

bool
LPseq::isA(ClassId id)
{
    return( id == ThisClassId );
}

void
LPseq::deliver( LP *xwho, LPmsg* what )
{
    LPseq *who = (LPseq *) xwho;

    what -> who(who);

    if ( what -> simulatedTime() == 0 ) {
	what -> simulatedTime( simulatedTime() );
    }

    TimeUnit when = what -> simulatedTime();

    //
    // can I execute it directly? -- this should always be safe
    //
    if ( what -> simulatedTime() <= simulatedTime() ) {
	TheLPmux -> directCall();
	who -> action( what );
    } else {
	TheLPmux -> add( what );
    }
}

void
LPseq::deliverSelf( LPmsg* what )
{
    LPseq *who = this;
    what -> who(who);

    if ( what -> simulatedTime() == 0 ) {
	what -> simulatedTime( simulatedTime() );
    }

    TimeUnit when = what -> simulatedTime();

    //
    // can I execute it directly? -- this should always be safe
    //
    if ( what -> simulatedTime() <= simulatedTime() ) {
	TheLPmux -> directCall();
	who -> action( what );
    } else {
	TheLPmux -> add( what );
    }
}


//
// Deliver an item, and it's the last thing to happen in this time slice
//
void
LPseq::deliverLast( LP *xwho, LPmsg* what )
{
    LPseq *who = (LPseq *) xwho;

    what -> who(who);

    if ( what -> simulatedTime() == 0 ) {
	what -> simulatedTime( simulatedTime() );
    }

    TimeUnit when = what -> simulatedTime();

    //
    // can I execute it directly?
    //
    if ( what -> simulatedTime() <= simulatedTime() ) {
	TheLPmux -> directCall();
	who -> action( what );
    } else {
	if ( TheLPmux -> directCallOk() ) {
	    TheLPmux -> directCall();
	    who -> action( what );
	}
	else {
	    TheLPmux -> add( what );
	}
    }
}

void
LPseq::action( LPmsg* what )
{
    assert( 0 );
}

void LPseq::divert(LPmsg *what, TimeUnit when)
{
    what -> simulatedTime( when );
    TheLPmux -> add( what );
}

void LPseq::busyUntil(TimeUnit time)
{
    LPmsg *event = new LPmsg(this, LPmsgTypeUnBusy, time);
    divert( event );
}

void LPseq::busyFor(TimeUnit time)
{
    time = simulatedTime() + time;
    LPmsg *event = new LPmsg(this, LPmsgTypeUnBusy, time);
    divert( event );
}
