#include <stream.h>
#include "LP.h"
#include <assert.h>

LP::LP(int ins, int outs)
{
    maxNumberOfInputs = ins;
    maxNumberOfOutputs = outs;

    if ( ins <= NumberOfDefaultLPOutputs ) {
	in = defaultInputs;
    } else {
	in = new LP *[ ins ];
    }

    if ( outs <= NumberOfDefaultLPOutputs ) {
	out = defaultOutputs;
    } else {
	out = new LPOutputToInputMapping [ outs ];
    }

    numberOfInputs = 0;
    for (int i = 0; i < maxNumberOfInputs; i++ ) {
	in[i] = 0;
    }

    numberOfOutputs = 0;
    for (int j = 0; j < maxNumberOfOutputs; j++ ) {
	out[j].lp = 0;
	out[j].theirInputNumber = -1;
    }
}

LP::~LP()
{
    if ( out && out != defaultOutputs ) {
	delete out;
    }
    if ( in && in != defaultInputs ) {
	delete in;
    }
}

int
LP::enrollInput(LP *lp)
{
    int slot = numberOfInputs;
    numberOfInputs++;

    if ( slot >= maxNumberOfInputs ) {
	cerr << "From object " << name() << "\n";
	cerr << "  You requested " << numberOfInputs << "inputs but only ";
	cerr << maxNumberOfInputs << " where allocated\n";
    }

    assert( slot < maxNumberOfInputs );

    in[ slot ] = lp;
    return( slot );
}

void
LP::enrollOutput(LP *lp)
{
    int slot = 0;

    while ( out[slot].lp != 0 && slot < maxNumberOfOutputs) {
	slot++;
    }

    numberOfOutputs++;
    assert( slot < maxNumberOfOutputs );

    out[ slot ].lp = lp;
    out[ slot ].theirInputNumber = lp -> enrollInput( this );
}

void
LP::enrollOutput(int slot, LP *lp)
{
    assert( slot >= 0 );
    assert( slot < maxNumberOfOutputs );
    assert( out[slot].lp == 0 );
    numberOfOutputs++;

    out[ slot ].lp = lp;
    out[ slot ].theirInputNumber = lp -> enrollInput( this );
}

void
LP::deliver( int channel, LPmsg& what )
{
    assert( 0 );
}

void
LP::deliverSelf(LPmsg& what )
{
    assert( 0 );
}

void
LP::deliverLast(int channel, LPmsg& what )
{
    assert( 0 );
}

void
LP::action( LPmsg& what )
{
    assert( 0 );
}
