#ifndef _LP_h_
#define _LP_h_

class LPmsg;
class LP;

static const int NumberOfDefaultLPOutputs = 10;

typedef struct {
    LP *lp;
    int theirInputNumber;
} LPOutputToInputMapping;

class LP {

protected:
    char *pName;
    char isSchedule();

    int numberOfOutputs;
    int maxNumberOfOutputs;
    LPOutputToInputMapping *out;
    LPOutputToInputMapping defaultOutputs[NumberOfDefaultLPOutputs];

    int numberOfInputs;
    int maxNumberOfInputs;
    LP **in;
    LP *defaultInputs[NumberOfDefaultLPOutputs];

public:
    LP(int numberOfInputs, int numberOfOutputs);
    virtual ~LP();

    void name(char *);
    char *name();

    //
    // enrollInput returns the input slot #.
    // who is the LP being wired into that slot number.
    // This is only called by enrollOutput.
    //
    virtual int enrollInput(LP *who);

    //
    // enrollOutput takes the desired output slot # and the LP
    // that should map to. It then sets up the internal data structures.
    //
    virtual void enrollOutput(LP *who);
    //
    // this just asserts that the selected channel number is the one used
    //
    virtual void enrollOutput(int channel, LP *who);

    //
    // deliver a message to another LP
    //
    virtual void deliver( int channel, LPmsg& what );
    virtual void deliverSelf(LPmsg& what );
    virtual void deliverLast( int channel, LPmsg& what );

    //
    // act on a message
    //
    virtual void action( LPmsg& what );
}; 

static inline char*
LP::name()
{
    return ( pName );
}

static inline void
LP::name(char *n)
{
    pName = n;
}

#endif
