#ifndef _LPmux_h_
#define _LPmux_h_

#include "LPmsg.SplayPQ.h"


class LPmux;
extern LPmux *TheLPmux;

class LPmux {
    LPmsgSplayPQ events;

    double CurrentSimulatedTime;

    int pDirectCalls;

public:
    
    LPmux();
    virtual ~LPmux();

    double simulatedTime();

    int directCallOk();
    void directCall();

    //
    // schedule a message - doesn't do much else...
    //
    void add(LPmsg&);
    void fireItUp();
}; 

static inline double
LPmux::simulatedTime()
{
    return ( CurrentSimulatedTime );
}

static inline void
LPmux::add(LPmsg& what)
{
    events.enq(what);
}

static inline int
LPmux::directCallOk()
{
    //
    // Limit the number of direct calls allowed (stack depth, basically)
    //
    return( events.empty() && pDirectCalls < 30 );
}

static inline void
LPmux::directCall()
{
    pDirectCalls++;
}

#endif
