#ifndef _LPseq_h_
#define _LPseq_h_

#include "LP.h"
#include "LPmux.h"

class LPseq : public LP {

public:

    LPseq(int numberOfInputs, int numberOfOutputs);

    //
    // deliver a message to another LPseq
    //
    double simulatedTime();
    //
    // deliver a message to another LP
    //
    virtual void deliver( int channel, LPmsg& what );
    virtual void deliverSelf(LPmsg& what );
    virtual void deliverLast( int channel, LPmsg& what );

    virtual void action( LPmsg& what);
};

static inline
LPseq::LPseq(int ins, int outs) : (ins,  outs)
{
    // does thing itself
}


static inline double
LPseq::simulatedTime()
{
    return ( TheLPmux -> simulatedTime() );
}

#endif
