/* 
Copyright (C) 1990 by Dirk Grunwald (grunwald@foobar.colorado.edu)

This file is part of Awesime.

Awesime is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY.  No author or distributor accepts responsibility to
anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Awesime, but only under the conditions described in the Gnu General
Public License.  A copy of this license is supposed to have been given
to you along with Awesime so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

*/

#ifdef __GNUG__
#  pragma implementation
#endif

#include <stream.h>
#include "BatchStatistic.h"
#include <math.h>

void
BatchStatistic::batch()
{
    batchStats += mean();
}

void
BatchStatistic::operator+=(double value)
{
    SampleStatistic::operator+=(value);
    if ( n >= pBatchTrigger ) {
	batch();
    }
}

void BatchStatistic::batchReset()
{
    batchStats.reset();
}

double BatchStatistic::batchSamples()
{
    return( batchStats.samples() );
}

double BatchStatistic::batchMean()
{
    return( batchStats.mean() );
}

double BatchStatistic::batchStdDev()
{
    return( batchStats.stdDev() );
}

double BatchStatistic::batchVar()
{
    return( batchStats.var() );
}

double BatchStatistic::batchMin()
{
    return( batchStats.min() );
}

double BatchStatistic::batchMax()
{
    return( batchStats.max() );
}

double BatchStatistic::batchSum()
{
    return( batchStats.sum() );
}

double BatchStatistic::batchConfidence(int p_percentage)
{
    return( batchStats.confidence(p_percentage) );
}
double BatchStatistic::batchConfidence(double p_value)
{
    return( batchStats.confidence(p_value) );
}

void
BatchStatistic::classPrintOn(ostream& st)
{
    st << batchStats.samples() << " " << batchStats.mean();
    st << " " << batchStats.stdDev() << " ";
    st << batchStats.confidence(90) << " " << batchStats.confidence(95);
    st << " " << batchStats.confidence(99);
}
