/* 
Copyright (C) 1990 by Dirk Grunwald (grunwald@foobar.colorado.edu)

This file is part of Awesime.

Awesime is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY.  No author or distributor accepts responsibility to
anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Awesime, but only under the conditions described in the Gnu General
Public License.  A copy of this license is supposed to have been given
to you along with Awesime so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

*/
// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef BatchStatistic_h_
#define BatchStatistic_h_

#ifdef __GNUG__
#  pragma interface
#endif

#include <SampleStatistic.h>
#include <stream.h>

class BatchStatistic : public SampleStatistic {
    int pBatchTrigger;
    SampleStatistic batchStats;
public:
    BatchStatistic( int trigger = 0 );

    int batchTrigger();
    void batchTrigger(int);

    virtual void operator+=(double);

    virtual void batch();
    virtual void batchReset();
    virtual double batchSamples();
    virtual double batchMean();
    virtual double batchStdDev();
    virtual double batchVar();
    virtual double batchMin();
    virtual double batchMax();
    virtual double batchSum();
    virtual double batchConfidence(int p_percentage);
    virtual double batchConfidence(double p_value);

    virtual void classPrintOn(ostream&);
};

BatchStatistic::BatchStatistic(int trigger)
{
    pBatchTrigger = trigger;
}

inline ostream&
operator<<(ostream& strm, BatchStatistic& ob)
{
    ob.classPrintOn(strm);
    return strm;
}

#endif BatchStatistic_h_
