/* 
Copyright (C) 1990 by Dirk Grunwald (grunwald@foobar.colorado.edu)

This file is part of Awesime.

Awesime is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY.  No author or distributor accepts responsibility to
anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Awesime, but only under the conditions described in the Gnu General
Public License.  A copy of this license is supposed to have been given
to you along with Awesime so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

*/
// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef CpuMuxP_h
#define CpuMuxP_h

#ifdef __GNUG__
#  pragma interface
#endif

#include <CpuMux.h>
#include <HardwareContext.h>
#include <HardwareContextP.h>
#include <SpinLock.h>
#include <Thread.h>

//
//	Expansions for exception handling
//
inline void
CpuMux::systemTransfer(Thread *thread)
{
    systemContext.switchContext(&(thread -> pContext));
}

inline void
CpuMux::threadTransfer(Thread *from, Thread *to)
{
    from -> pContext.switchContext(&(to -> pContext));
}

inline void
CpuMux::raise(ExceptionClass *by)
{
    assert( by != 0 );
    ThisCpu -> raisedBy = by;
    ThisCpu -> currentThread -> pContext.switchContext( &(ThisCpu -> systemContext) );
}

inline void
CpuMux::reserveByException( ReserveByException *sem )
{
    ThisCpu -> reserveException.reserve(sem);
    ThisCpu -> raise( &(ThisCpu -> reserveException) );
}

inline void
CpuMux::threadTerminateException( Thread *killMe )
{
    ThisCpu -> terminateException.terminate( killMe );
    ThisCpu -> raise( &(ThisCpu -> terminateException) );
}

#endif /* CpuMuxP_h */
