/* 
Copyright (C) 1990 by Dirk Grunwald (grunwald@foobar.colorado.edu)

This file is part of Awesime.

Awesime is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY.  No author or distributor accepts responsibility to
anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Awesime, but only under the conditions described in the Gnu General
Public License.  A copy of this license is supposed to have been given
to you along with Awesime so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

*/
// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
//
// Define the following things:
//	HEAP_NAME	-- the name of the heap type
//	HEAP_INDEX	-- the index type; defaults to unsigned short
//	HEAP_INDEX_NULL	-- the null value for the heap index; defaults to 65535
//	HEAP_BASE_CLASS	-- the base class for the new heap
//
// Furthermore, the item type should be a type with the name
//	GENERIC2(HEAP_NAME,Item)
//
// This type can be anything (simple, class, typedef) that provides
// comparison operatiohns.
//

#include <Awesime.h>
#include <Generic.h>

#ifndef HEAP_INDEX
#define HEAP_INDEX unsigned short
#endif

#ifndef HEAP_INDEX_NULL
#define HEAP_INDEX_NULL 0xffff
#endif

#ifndef HEAP_BASE_CLASS
#define HEAP_BASE_CLASS public Awesime
#endif

//
//	The following are simplifications of the preceeding names;
//	they make the following code much more readable
//
//	However, for safety, they are undef'd at the end of the .h file,
//	so you'll need to re-def them in your .cc file if you want to use them.
//

#define NIL	GENERIC2(HEAP_NAME,Null)
#define INDEX	GENERIC2(HEAP_NAME,Index)
#define ITEM	GENERIC2(HEAP_NAME,Item)
#define RECORD	GENERIC2(HEAP_NAME,Record)

typedef HEAP_INDEX INDEX;

extern const INDEX NIL;

typedef struct {
    ITEM item;
    INDEX sibling;
    INDEX children;
} RECORD;

class HEAP_NAME : HEAP_BASE_CLASS {

    RECORD *storage;
    bool *pValid;
    int elements;
    INDEX allocatedSize;
    INDEX freelist;
    INDEX root;

    void makeRoom(int atLeast);
    INDEX getCell();
    void  returnCell(INDEX cell);
    INDEX makeChild(INDEX a, INDEX b);

public:
    HEAP_NAME(int length = 0, bool xdebug = 0);

    virtual void add(ITEM &item);
    virtual bool remove(ITEM &removed);
    
    //
    //	The next four members allow you to search a HEAP_NAME and mark
    //	items as invalid. 
    //
    //	doStart initilizes the index and returns the first item in the list.
    //	doNext moves to the next item and returns that item.
    //	Both return a bool indicating whether the value in item has any
    //	meaning. When bool=FALSE, you've searched everything.
    //  Call doDone at the end to insure compatibility with subclasses.
    //

    virtual bool doStart( INDEX &index);
    virtual bool doDelete(INDEX &index);
    virtual bool doNext( INDEX &index);
    virtual void doDone();

    INDEX minItem();
    bool valid(INDEX index);
    ITEM & item(INDEX i);
    INDEX maxIndex();
    bool isEmpty();
    unsigned int size();
    virtual void classPrintOn(ostream& s);
};

inline INDEX HEAP_NAME::minItem() {
     return(root);
 };
 
 inline bool HEAP_NAME::valid(INDEX index) {
     return ( pValid[index] );
 }
 
 inline ITEM & HEAP_NAME::item(INDEX i) {
     return( storage[i].item );
 }
 
 inline INDEX HEAP_NAME::maxIndex() {
     return(allocatedSize);
 }
 
 inline bool HEAP_NAME::isEmpty() {
    if ( elements <= 0 ) {
	return (TRUE);
    } else {
	return (FALSE);
    }
 }
 
 inline unsigned int HEAP_NAME::size() {
     return(elements);
 }
 
#undef RECORD
#undef INDEX
#undef ITEM
#undef NIL

#undef HEAP_NAME
#undef HEAP_ITEM
#undef HEAP_INDEX
#undef HEAP_INDEX_NULL
#undef HEAP_BASE_CLASS

