
#ifdef __GNUG__
#  pragma implementation
#endif

#include "CpuMux.h"
#include "CpuMuxP.h"
#include "Join.h"
#include "Thread.h"

Join::Join(Thread *child_)
{
    child = child_;
    childWaiting = FALSE;
    returnValue = 0;
    parent = 0;
};

Join::~Join()
{
    lock.reserve();

    // this is messy

    lock.release();
}

void *
Join::parentJoin()
{
    lock.reserve();
    bool waiting = childWaiting;
    lock.release();

    if ( ! waiting ) {
	CpuMux::Cpu() -> reserveByException( this );
	//
	// execution resumes here when child is finally waiting
	assert( childWaiting );
    }

    lock.reserve();
    delete child;
    lock.release();

    return (returnValue);
}

void Join::childJoin(void *rv)
{
    returnValue = rv;
    CpuMux::Cpu() -> reserveByException( this );
    //
    // child should never returns
    //
    assert( 0 );
}

//
//	This is only executed in the context of a CpuMux, never
//	a thread.
//
int
Join::reserveByException(Thread *byWho, ExceptionReserve&)
{
    bool blocked = FALSE;
    lock.reserve();
    if ( byWho == child ) {
	//
	// we're child, return TRUE to indicate we're blocked
	//
	childWaiting = TRUE;
	blocked = TRUE;
	if ( parent != 0 )  {
	    CpuMux::Cpu() -> add ( parent );
	}
    } else {
	//
	// we're parent
	//
	if ( childWaiting ) {
	    blocked = FALSE;
	    //
	    // we will resume after the reserveByException in parentJoin
	    //
	} else {
	    //
	    // wait for the kid
	    //
	    parent = byWho;
	    blocked = TRUE;
	}
    }
    lock.release();
    return( blocked );
}
