// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//

#ifdef __GNUG__
#  pragma implementation
#endif

#include "MultiCpuMuxExceptions.h"
#include "ReserveByException.h"
#include "ExceptionClassP.h"
#include "CpuMux.h"
#include "CpuMuxP.h"
#include "HardwareContextP.h"
#include "MultiCpuMux.h"
#include "SpinBarrier.h"
#include "stream.h"
#include "Thread.h"

void
ExceptionRelocate::handleException()
{
    //
    // Switch to another thread when we havenot gotten
    // rid of the current one.
    //
#ifndef NDEBUG
    if (CpuMux::debug()) {
	CpuMux::CerrLock.reserve();
	cerr << CpuMux::name() << " reschedule exception to ";
	cerr << newCpu << "\n";
	CpuMux::CerrLock.release();
    }
#endif /* NDEBUG */

    Thread *t = CpuMux::CurrentThread();
    assert(t != 0 );
    MultiCpuMux::addToAnother(newCpu, t);
    setCurrentThread( 0 );
}

//
//	Used to add or remove CPUs from the current pool of CPUs
//

static SpinBarrier TwoCpuBarrier(2);

void
ExceptionEnrollDismissCpu::handleException()
{
    MultiCpuMux *cpu = (MultiCpuMux *) CpuMux::Cpu();
    if (enrollOrDismiss) {
	//
	// enroll
	//
	assert( cpu -> cpuId() == 0 );
	//
	//
	// Now fork the child. We need to insure that the new child
	// and the parent leave only after the data structures have been
	// created, otherwise barriers in subclasses may have problems.
	//
	int pid = fork();
	if ( pid == 0 ) {
	    cpu -> iYam = CpuMux::Muxs;
	    //
	    // CpuMux::allocateEventStructures will set CpuMux::Muxs
	    //
	    cpu -> allocateLocalEventStructures(cpu -> iYam,
						CpuMux::Muxs+1 );
	    //
	    // cause child to schedule new process at stirItAround
	    //
	    cpu -> currentThread = 0;
	    cpu -> pid = getpid();
	}
	TwoCpuBarrier.rendezvous();
    }
    else {
	//
	// dismiss
	//
	assert( 0 );
    }
}
