// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef MultiMuxCpu_h
#define MultiMuxCpu_h
#ifdef __GNUG__
#  pragma interface
#endif

#include <SimMux.h>
#include <MultiCpuMux.h>
#include <HardwareContext.h>

//
//	Like it says.
//

class SpinBarrier;
class SEvPQ;
class SEv;

class MultiSimMux : public SimMux {
protected:

    SEv *currentEvent;

    virtual int advanceTime();
    virtual void allocateLocalEventStructures(int,int);
    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void addAt_(Thread *, SimTimeUnit);
    virtual void addAt_(OEv *, SimTimeUnit);
    virtual void await_(SimTimeUnit);

public:
    MultiSimMux(bool debug = FALSE);

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
};

#endif /* MultiMuxCpu_h */
