// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef SimMux_h
#define SimMux_h
#ifdef __GNUG__
#  pragma interface
#endif

#include <CpuMux.h>
#include <HardwareContext.h>
#include "TimeUnit.h"

class OEv;


class SimMux : public CpuMux {

protected:
    static SimTimeUnit CurrentSimulatedTime;
    static const SimTimeUnit NullSimulatedTime;
    static SimMux *ThisSimMux;

protected:
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void addAt_(Thread *, SimTimeUnit);
    virtual void addWithDelay_(Thread *, SimTimeUnit);
    virtual void addAt_(OEv *, SimTimeUnit);
    virtual void addWithDelay_(OEv *, SimTimeUnit);
    virtual void hold_( SimTimeUnit time );
    virtual void await_( SimTimeUnit time );

public:
    SimMux(bool debug = FALSE);
    ~SimMux();

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));

    static SimMux *Sim();
    static SimTimeUnit CurrentTime();
    static SimTimeUnit NullTime();

    static void addAt(Thread *, SimTimeUnit);
    static void addWithDelay(Thread *, SimTimeUnit);
    static void addAt(OEv *, SimTimeUnit);
    static void addWithDelay(OEv *, SimTimeUnit);
    static void hold( SimTimeUnit time );
    static void await( SimTimeUnit time );

};


inline SimMux*
SimMux::Sim()
{
    return( ThisSimMux );
}

inline SimTimeUnit 
SimMux::CurrentTime()
{
    return( CurrentSimulatedTime );
}

inline SimTimeUnit 
SimMux::NullTime()
{
    return( NullSimulatedTime );
}

inline void
SimMux::hold(SimTimeUnit holdFor)
{
    ThisSimMux -> await_( CurrentSimulatedTime + holdFor );
}

inline void 
SimMux::await(SimTimeUnit till)
{
    if ( till > CurrentSimulatedTime ) {
	ThisSimMux -> await_(till);
    }
}

inline void
SimMux::addAt(Thread *t, SimTimeUnit holdFor)
{
    ThisSimMux -> addAt_(t, holdFor);
}

inline void
SimMux::addWithDelay(Thread *t, SimTimeUnit holdFor)
{
    ThisSimMux -> addWithDelay_(t, holdFor);
}

inline void
SimMux::addAt(OEv *o, SimTimeUnit holdFor)
{
    ThisSimMux -> addAt_(o, holdFor);
}

inline void
SimMux::addWithDelay(OEv *o, SimTimeUnit holdFor)
{
    ThisSimMux -> addWithDelay_(o, holdFor);
}

#endif /* SimMux_h */
