/* 
Copyright (C) 1990 by Dirk Grunwald (grunwald@foobar.colorado.edu)

This file is part of Awesime.

Awesime is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY.  No author or distributor accepts responsibility to
anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Awesime, but only under the conditions described in the Gnu General
Public License.  A copy of this license is supposed to have been given
to you along with Awesime so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

*/
// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifdef __GNUG__
#  pragma implementation
#endif

//#include <builtin.h>
#include <assert.h>
#include "TimeSchedulerPQ.h"


// non-implemented virtuals
// these are defined to do nonsensical but type-legal things
// They need to be defined in order to fill the vtable

Pix   TimeSchedulerPQ::enq(TimeScheduler&)       { error("unimplemented"); return 0; }
void  TimeSchedulerPQ::del_front()     { error("unimplemented"); }
void  TimeSchedulerPQ::del(Pix)        { error("unimplemented"); }
Pix   TimeSchedulerPQ::first()         { error("unimplemented"); return 0; }
void  TimeSchedulerPQ::next(Pix&)      { error("unimplemented"); }
TimeScheduler&  TimeSchedulerPQ::operator()(Pix) { error("unimplemented"); return *((TimeScheduler*)0); }
TimeScheduler&  TimeSchedulerPQ::front()         { error("unimplemented"); return *((TimeScheduler*)0); }
int   TimeSchedulerPQ::OK()            { error("unimplemented"); return 0; }

TimeScheduler TimeSchedulerPQ::deq()
{
//  TimeScheduler x = front();
  TimeScheduler x; x = front();
  del_front();
  return x;
}

Pix TimeSchedulerPQ::seek(TimeScheduler& item)
{
  for (Pix i = first(); i != 0 && !(TimeSchedulerEQ((*this)(i), item)); next(i));
  return i;
}

int TimeSchedulerPQ::owns(Pix idx)
{
  if (idx == 0) return 0;
  for (Pix i = first(); i; next(i)) if (i == idx) return 1;
  return 0;
}

void TimeSchedulerPQ::clear()
{
  while (count != 0) del_front();
}

int TimeSchedulerPQ::contains (TimeScheduler& item)
{
  return seek(item) != 0;
}


void TimeSchedulerPQ::error(char* msg)
{
//  (*lib_error_handler)("PQ", msg);
    assert2(0,msg);
}

