// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _TimeSchedulerSplayPQ_h
#define _TimeSchedulerSplayPQ_h 1

#ifdef __GNUG__
#  pragma interface
#endif

#include "TimeSchedulerPQ.h"

#ifndef _TimeSchedulerSplayNode
#define _TimeSchedulerSplayNode 1

struct TimeSchedulerSplayNode
{
  TimeSchedulerSplayNode*   lt;
  TimeSchedulerSplayNode*   rt;
  TimeSchedulerSplayNode*   par;
  TimeScheduler             item;
                  TimeSchedulerSplayNode(TimeScheduler& h, TimeSchedulerSplayNode* l=0, TimeSchedulerSplayNode* r=0);
                  ~TimeSchedulerSplayNode();
};


inline TimeSchedulerSplayNode::TimeSchedulerSplayNode(TimeScheduler& h, TimeSchedulerSplayNode* l=0, TimeSchedulerSplayNode* r=0)
{
  item = h;
  lt = l;
  rt = r;
  par = 0;
}

inline TimeSchedulerSplayNode::~TimeSchedulerSplayNode() {}

typedef TimeSchedulerSplayNode* TimeSchedulerSplayNodePtr;

#endif

class TimeSchedulerSplayPQ : public TimeSchedulerPQ
{
protected:
  TimeSchedulerSplayNode*   root;

  TimeSchedulerSplayNode*   leftmost();
  TimeSchedulerSplayNode*   rightmost();
  TimeSchedulerSplayNode*   pred(TimeSchedulerSplayNode* t);
  TimeSchedulerSplayNode*   succ(TimeSchedulerSplayNode* t);
  void            _kill(TimeSchedulerSplayNode* t);
  TimeSchedulerSplayNode*   _copy(TimeSchedulerSplayNode* t);

public:
                  TimeSchedulerSplayPQ();
                  TimeSchedulerSplayPQ(TimeSchedulerSplayPQ& a);
                  ~TimeSchedulerSplayPQ();

  Pix           enq(TimeScheduler& item);
  TimeScheduler           deq(); 

  TimeScheduler&          front();
  void          del_front();

  int           contains(TimeScheduler& item);

  void          clear(); 

  Pix           first(); 
  Pix           last(); 
  void          next(Pix& i);
  void          prev(Pix& i);
  TimeScheduler&          operator () (Pix i);
  void          del(Pix i);
  Pix           seek(TimeScheduler& item);

  int           OK();                    // rep invariant
};

inline TimeSchedulerSplayPQ::~TimeSchedulerSplayPQ()
{
  _kill(root);
}

inline TimeSchedulerSplayPQ::TimeSchedulerSplayPQ()
{
  root = 0;
  count = 0;
}

inline TimeSchedulerSplayPQ::TimeSchedulerSplayPQ(TimeSchedulerSplayPQ& b)
{
  count = b.count;
  root = _copy(b.root);
}

inline Pix TimeSchedulerSplayPQ::first()
{
  return Pix(leftmost());
}

inline Pix TimeSchedulerSplayPQ::last()
{
  return Pix(rightmost());
}

inline void TimeSchedulerSplayPQ::next(Pix& i)
{
  if (i != 0) i = Pix(succ((TimeSchedulerSplayNode*)i));
}

inline void TimeSchedulerSplayPQ::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((TimeSchedulerSplayNode*)i));
}

inline TimeScheduler& TimeSchedulerSplayPQ::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((TimeSchedulerSplayNode*)i)->item;
}

inline void TimeSchedulerSplayPQ::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int TimeSchedulerSplayPQ::contains(TimeScheduler& key)
{
  return seek(key) != 0;
}


#endif
