%{
/* This is a character translator used to 
 * translate doc to help file
 */
 int inbq = 0;
 int init = 0;
 int intt = 0;
 int inverb = 0;
%}

%%
\\\\			{  fputc('\n', yyout); if (inbq) fputs("     ", yyout); }
\\\\\n			{  fputc('\n', yyout); if (inbq) fputs("     ", yyout); }
\n				{ fputc('\n', yyout); }
[ ]*\\bq[ \n]*	{ inbq = 1; fputs("     ", yyout); }
[ ]*\\eq[ ]*	{ inbq = 0; }
[{]\\it[ ]*\n[ ]* 	{ init = 1; fputs("\n ", yyout); fputc('"', yyout); }
[{]\\tt[ ]*\n[ ]*   { intt = 1; fputs("\n ", yyout); fputc('`', yyout); }
[{]\\it[ ]* 	{ init = 1; fputc('"', yyout); }
[{]\\tt[ ]*	    { intt = 1; fputc('`', yyout); }
[}]				{ if (init) {
					fputc('"', yyout);
					init = 0;
				  } else if (intt) {
					fputc('\'', yyout);
					intt = 0;
				  }
				  else if (inverb) {
					fputc('}', yyout);
				  }
				  ;
				}
[ ]*\\Seealso 		{ fprintf(yyout, " See also:"); }
[ ]*\\Examples 		{ fprintf(yyout, " Examples:"); }
[ ]*\\Example 		{ fprintf(yyout, " Example:"); }
[ ]*\\Syntax 		{ fprintf(yyout, " Syntax:"); }
\\optio 		{ fprintf(yyout, "(optional)"); }
\\times 		{ fprintf(yyout, "X"); }
\\fudgit[\\]? 		{ fprintf(yyout, "FUDGIT"); }
\\gnuplot[\\]? 		{ fprintf(yyout, "GNUPLOT"); }
\\sgiplot[\\]? 		{ fprintf(yyout, "SGIPLOT"); }
\\readline[\\]? 	{ fprintf(yyout, "READLINE"); }
\\unix[\\]? 		{ fprintf(yyout, "UNiX"); }
\\hoc[\\]? 		{ fprintf(yyout, "HOC"); }
\\emacs[\\]? 		{ fprintf(yyout, "EMACS"); }
[ ]*[$]\\bullet[$]	{ fprintf(yyout, "   => "); }
[$]\\backslash[$] 	{ fputc('\\', yyout); }
\\verb[+]\\[+]	{ fputc('\\', yyout); }
\\verb[+]\\t[+]	{ fputs("\\t", yyout); }
\\verb[+]\\n[+]	{ fputs("\\n", yyout); }
\\verb[+]\\a[+]	{ fputs("\\a", yyout); }
\\[%]				{ fputc('%', yyout); }
\\[$]				{ fputc('$', yyout); }
\\[&]				{ fputc('&', yyout); }
\\[#]				{ fputc('#', yyout); }
\\[^][{][ ][}]  { fputc('^', yyout); }
\\_				{ fputc('_', yyout); }
\\[}]			{ fputc('}', yyout); }
\\dash				{ fputc('-', yyout); }
\\[{]			{ fputc('{', yyout); }
\\ldots			{ fputs("...", yyout); }
\\				{ ; }
[{]				{ if (inverb) fputc('{', yyout); }
[$]				{ if (inverb) fputc('$', yyout); }
\\nopagebreak\\begin[{]verbatim[}][ ]*\n	{ inverb = 1;}
\\end[{]verbatim[}][ ]*\n 	{ inverb = 0; }
[a-zA-Z0-9*%@#!&()]* 		{ fprintf(yyout, "%s", yytext); }
%%

extern FILE *yyin, *yyout;

main(argc, argv)
int argc;
char **argv;
{

	FILE *fp;

	if (argc < 1 && 3 < argc) {
		fprintf(stderr, "Usage: %s infile [outfile]\n", argv[0]);
		exit(1);
	}
	switch (argc) {
		case 3:
		fclose(stdout);
		if ((yyout = fopen (argv[2], "w")) == NULL) {
			fprintf(stderr, "%s: Permission denied.\n", argv[0]);
			exit(1);
		}
		case 2:
		fclose(stdin);
		if ((yyin = fopen (argv[1], "r")) == NULL) {
			fprintf(stderr, "%s: file not found\n", argv[0]);
			exit(1);
		}
		break;
		case 1:
		/* filter mode  */
		break;
	}

	yylex();
	exit(0);
}

