/* Version of alloc.c using alloca macros instead of alloc */

#include <ctype.h>

#ifdef __GNUC__
#define alloca __builtin_alloca
#else
#if defined (sparc) || defined (sgi)
#include <alloca.h>
#endif
#endif

#ifndef __STDIO_H___
#include <stdio.h>
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef ERRR
#define ERRR (-1)
#endif

#define ERROR(string, action) {\
    fprintf(stderr, "%s: Allocation error.\n", string);\
    action(ERRR);\
}

#define AIVECTOR(v, nl, nh, func, act) { \
    v=(int *)alloca((unsigned) (nh-nl+1) * sizeof(int)); \
    if (v == (int *)NULL) {\
        ERROR(func, act);\
    }\
    v-=nl;\
}
	/* bzero((void *)v, (nh-nl+1) * sizeof(int));\ */
 
#define ADVECTOR(v, nl, nh, func, act) {\
    v=(double *)alloca((unsigned) (nh-nl+1) * sizeof(double)); \
    if (v == (double *)NULL) {\
        ERROR(func, act);\
    }\
    v-=nl;\
} 
	/* bzero((void *)v, (nh-nl+1) * sizeof(double));\ */
 
#define ADMATRIX(m, nrl, nrh, ncl, nch, func, act)  {  \
    double *ddp; \
    int ii;\
 \
    m=(double **)alloca((unsigned) (nrh-nrl+1) * sizeof(double*)); \
    if (m == (double **)NULL) {\
        ERROR(func, act);\
    }\
    m -= nrl; \
 \
    for(ii=nrl;ii<=nrh;ii++) { \
        ddp=(double *)alloca((unsigned) (nch-ncl+1) * sizeof(double)); \
        if (ddp == (double *)NULL) {\
            ERROR(func, act);\
        }\
        m[ii] = ddp - ncl; \
    } \
} 
		/* bzero((void *)ddp, (nch-ncl+1) * sizeof(double));\ */

