/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;

Pint ee,ii,nsteps,i,j;

Pfloat dt,t1,t2;
Pmatrix3 xx;
PR_dir  tnew= {0};

void putpoint3(C(FILE *)fp, C(Ppoint3)xx)
PreANSI(FILE *fp)
PreANSI(Ppoint3 xx)
{
fprintf(fp,"%12.4g%12.4g%12.4g",xx.x,xx.y,xx.z);
}

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  LINE;
  nrb_init(3,13,4,24,&s1);
  
  nrb_makeknots(0.0,1.0,&s1.pf_u);
  nrb_makeknots(0.0,1.0,&s1.pf_v);

  for (i=1; i<=s1.pf_u.pf_n;i++)
     for (j=1; j<=s1.pf_v.pf_n;j++){
      t1 = i;
      t2 = j;	
      s1.pf_ppp->pts[nrb_index(i,j,s1.pf_u.pf_n)-1] = tp_litv4(t1,t2,0.0,1.0);
     }

  printf("Dump of before nrb_transpose\n");
  nrb_dump(stdout,&s1);

  LINE;
  
  nrb_transpose(&s1);
  printf("Dump of output from nrb_transpose\n");
  nrb_dump(stdout,&s1);  

  LINE;
  nrb_init(2,4,3,8,&s1);
  nrb_makeknots(0.0,1.0,&s1.pf_u);
  nrb_makeknots(0.0,1.0,&s1.pf_v);

  printf("Dump of before nrb_Xtranspose\n");
  
  for (i=1; i<=s1.pf_u.pf_n;i++)
     for (j=1; j<=s1.pf_v.pf_n;j++){
      t1 = i;
      t2 = j;	
      s1.pf_ppp->pts[nrb_index(i,j,s1.pf_u.pf_n)-1] = tp_litv4(t1,t2,0.0,1.0);
     }

  nrb_dump(stdout,&s1);
  LINE;

  printf("Dump of output from nrb_Xtranspose\n");
  nrb_Xtranspose(&s1);
  nrb_dump(stdout,&s1);

  LINE;
  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
}

/* End. */
