/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include <stdio.h>
#include <math.h>
#include "ptktype.h"
#include "trantype.h"
#include "machine.h"
#include "tranfns.h"


Pmatrix3 matrix, matrix1, matrix2;
Pvector3 dv1, dv2, point;
Ppoint3 pt1, pt2;
Pfloat ctheta, stheta;
Plimit3 windo, vuport;
Pint err;

main()
{
  printf("Testing the `transforms' module of the PHIGS Toolkit...\n");

  printf("Testing ptk_unitmatrix3()...\n");
  ptk_unitmatrix3(matrix);
  ptk_outputmatrix3(stdout, matrix, "Unit Matrix");
  point = ptk_vector3(10.0, 20.0, 30.0);

  ctheta = cos(30.0 * 3.14159263 / 180.0);
  stheta = sin(30.0 * 3.14159263 / 180.0);

  printf("Testing ptk_shift3()...\n");
  ptk_shift3(&point, PPRECONCATENATE, matrix);
  ptk_outputmatrix3(stdout, matrix, "Matrix after first shift");

  ptk_shift3(&point, PPRECONCATENATE, matrix);
  ptk_outputmatrix3(stdout, matrix, "Matrix after second shift");

  ptk_shift3(&point, PREPLACE, matrix);
  ptk_outputmatrix3(stdout, matrix, "Matrix replaced");

  memcpy(matrix1, matrix, sizeof(Pmatrix3));
 
  printf("Testing ptk_scale3()...\n");
  ptk_scale3(&point, PPRECONCATENATE, matrix);
  ptk_outputmatrix3(stdout, matrix, "Matrix after first scale(pre-concatenate)");

  ptk_scale3(&point, PPOSTCONCATENATE, matrix1);
  ptk_outputmatrix3(stdout, matrix1, "Matrix after first scale(post-concatenate)");

  printf("Testing ptk_rotatecs3()...\n");
  ptk_rotatecs3(ctheta, stheta, PTKEXAXIS, PREPLACE, matrix1);
  ptk_outputmatrix3(stdout, matrix1, "Matrix after rotation(cs) about x");

  ptk_rotatecs3(ctheta, stheta, PTKEYAXIS, PREPLACE, matrix1);
  ptk_outputmatrix3(stdout, matrix1, "Matrix after rotation(cs) about y");

  ptk_rotatecs3(ctheta, stheta, PTKEZAXIS, PREPLACE, matrix1);
  ptk_outputmatrix3(stdout, matrix1, "Matrix after rotation(cs) about z");

  printf("Testing ptk_rotate3()...\n");
  ptk_rotate3(30.0, PTKEYAXIS, PREPLACE, matrix1);
  ptk_outputmatrix3(stdout, matrix1, "Matrix after rotation about y");

  ptk_rotate3(30.0, PTKEZAXIS, PREPLACE, matrix1);
  ptk_outputmatrix3(stdout, matrix1, "Matrix after rotation about z");

  dv1 = ptk_vector3(0.0, 0.0, 1.0);
  dv2 = ptk_vector3(ctheta, stheta, 0.0);

  printf("Testing ptk_rotatevv3()...\n");
  ptk_rotatevv3(&dv1, &dv2, PREPLACE, matrix, &err);
  ptk_outputmatrix3(stdout, matrix, "Matrix after ptk_rotatevv3");

  printf("Testing ptk_rotateline3()...\n");
  pt1 = ptk_vec3topt3(&dv1);
  pt2 = ptk_vec3topt3(&dv2);
  ptk_rotateline3(&pt1, &pt2, 30.0, PREPLACE, matrix, &err);
  ptk_outputmatrix3(stdout, matrix, "Matrix after ptk_rotateline3");

  printf("Testing ptk_stack()...\n");
  ptk_stackmatrix3(matrix);

  printf("Testing ptk_unstack()...\n");
  ptk_unstackmatrix3(matrix);
  ptk_outputmatrix3(stdout, matrix, "Matrix after stack and unstack");

  printf("End of transforms test.\n");
  exit(0);
}

/* End. */
