/*
   This example defines a processor set for the rows and for the columns of
   a mesh, then tests a global operation on these processor subsets
 */

#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"

extern int main2();

main(argc,argv)
int argc;
char **argv;
{
PICall( main2, argc, argv );
}

int main2( argc, argv )
int argc;
char **argv;
{
int     row, col, nrows, ncols,i;
double  vrow, vcol, work;
ProcSet *prow, *pcol;

nrows = 2;
ncols = 2;
SYArgGetInt( &argc, argv, 1, "-r", &nrows );
SYArgGetInt( &argc, argv, 1, "-c", &ncols );
if (nrows * ncols != NUMNODES) {
    fprintf( stderr, "[%d,%d] doesn't fit in %d processors\n", nrows, ncols, 
	     NUMNODES );
    SYexitall("",1);
    }
/* PISetLogging( 3 ); */

row = MYPROCID % nrows;
col = (MYPROCID / nrows);

/* note that first arguments must be distinct in different calls to */
/* PSPartition and greater then 0 */
prow = PSPartition( row + 1, (ProcSet *)0 );
pcol = PSPartition( col + nrows + 1, (ProcSet *)0 );

for (i=0; i<=NUMNODES; i++) {
    if (GTOKEN((ProcSet*)0,i)) {
	printf( "Row procset for processor %d\n", MYPROCID );
	PSPrintProcset( prow, ncols, stdout );
	printf( "Column procset for processor %d\n", MYPROCID );
	PSPrintProcset( pcol, ncols, stdout );
	}
    }

vrow = vcol = (double) MYPROCID;
LOGEVENT(10);
GDSUM( &vrow, 1, &work, prow );
GDSUM( &vcol, 1, &work, pcol );
LOGEVENT(11);

/* test the results */
if (vrow != (double)( ncols*row + nrows*((ncols-1)*ncols)/2 ))
    fprintf( stderr, "Wrong sum [%lf] for rows on processor %d\n", 
	              vrow, MYPROCID );
if (vcol != (double)( nrows*(col * nrows) + ((nrows-1)*nrows)/2 ))
    fprintf( stderr, "Wrong sum [%lf] for cols on processor %d\n", 
	              vcol, MYPROCID );

fprintf( stderr, "Now testing token \n");

for ( i=0; i<=NUMNODES; i++ ) {
    if (GTOKEN((ProcSet*)0,i)) printf("It is my turn %d \n",MYPROCID);
    }

fprintf( stderr, "[%d] End of run for example1 \n", MYPROCID );

return 0;
}    
