C         
C        This is a test program that uses subsets.
C        This program tests a wide variety of subsets by generating a 
C        matrix of size (nx x ny), with nx * nx = np, and computing row, 
C        column, and a collection of matrix (lower principle minors)
C
      subroutine worker()
      integer          nx, ny, np, myid
      double precision matrix(1024)
      include '../fcomm.h'
C
C     Compute the matrix size
C
      np = PInumtids()
      nx = sqrt( float(np) )
      ny = np / nx
      if (ny * nx .ne. np) then
         print *, 'Can not subdivide into a matrix'
         return
      endif
      call setmatrix( matrix, nx, ny )
      call testmatrix( matrix, nx, ny )
      return 
      end
    

      subroutine setmatrix( m, nx, ny )
      integer nx, ny
      double precision m(nx,ny)
      integer i, j
      do 10 j=1, ny
         do 10 i=1, nx
            m(i,j) = i + nx * (j-1)
 10   continue
      return
      end

      subroutine testmatrix( m, nx, ny )
      integer nx, ny
      double precision m(nx,ny)
      integer row, col, np, myid, prow, pcol, errors, psubmat, pval
      integer i, j, ii, jj
      double precision rowsum, colsum, prowsum, pcolsum, work, psubsum
      include '../fcomm.h'
c
c     Compute the row and column of this processor
c
      np   = PInumtids()
      myid = PImytid()
      col  = myid / nx 
      row  = myid - col * nx
      col  = col + 1
      row  = row + 1
      if (row .gt. nx) row = nx
      if (col .gt. ny) col = ny
C
C     Compute the row and column procsets
C
      prow = pspartition(row,0)
      pcol = pspartition( nx + col, 0 )
C
C    Compute the actual values
C      
      rowsum = 0.0
      colsum = 0.0
      do 10 j=1, ny
 10      rowsum = rowsum + m(row,j)
      do 20 i=1, nx
 20      colsum = colsum + m(i,col)
C
      prowsum = m(row,col)
      pcolsum = prowsum
      call pigdsum( prowsum, 1, work, prow )
      call pigdsum( pcolsum, 1, work, pcol )
C
C     check the results
C
      errors = 0
      if (prowsum .ne. rowsum) then
         print *, 'Rowsum wrong on processor ', myid
         errors = errors + 1
      endif
      if (pcolsum .ne. colsum) then
         print *, 'Colsum wrong on processor ', myid
         errors = errors + 1
      endif
C
      call pigisum( errors, 1, work, 0 )
      if (errors .gt. 0) return
C
C     Continue with descending subminors, this time partitioning submatrics
C
      psubmat = 0
      do 30 j=1, nx
         pval = nx + ny + j
         if (row .lt. j) pval = -1
         psubmat = pspartition( pval, psubmat )
         if (psubmat .eq. 0) goto 50
         psubsum = m(row,col)
         call pigdsum( psubsum, 1, work, psubmat )
C
C        compare with the actual sum
C
         rowsum = 0.0
         do 40 jj=j,nx
            do 40 i=1,ny
 40            rowsum = rowsum + m(jj,i)
         if (rowsum .ne. psubsum) then
            errors = errors + 1
            print *, 'submatrix sum failed for ', myid, ' at row ', j
            print *, 'Got ', psubsum, ' expected ', rowsum
         endif
 30      continue
 50      continue
C
         call pigisum( errors, 1, work, 0 )
         if (errors .gt. 0) return
C
         if (myid .eq. 0) print *, 'No errors'
         return
         end

