#ifndef lint
static char SCCSid[] = "@(#) ./comm/fcall.c 07/23/93";
#endif

/*
   This file contains Fortran interfaces for the communication routines
   and macros.

   Define OLD_PICALL to use the 6-argument version.
 */

#include "tools.h"
#include "comm/comm.h"
#include "comm/procset.h"
#include <stdio.h>
typedef int POINTER;

#if defined(FORTRANCAPS)
#define picall_ PICALL
#elif !defined(FORTRANUNDERSCORE)
#define picall_ picall
#endif

#ifdef OLD_PICALL
picall_( np, pg, pf, routine, argc, argv, d )
int *np, *argc, d;
char *pg, *pf, **argv;
int  (*routine)();
{
#else
picall_( routine, argc, argv )
int  *argc;
char **argv;
int  (*routine)();
{
#endif
char *buf;
int  Argc, i, setargs = 0, argsize=40;
char **Argv, *p;

#ifdef OLD_PICALL
/* Make a null-terminated copy of the string */
if (d == 0 || (d == 1 && pf[0] == ' '))
    buf = (char *)0;
else {
    buf = (char *)MALLOC( (d+1) );
    strncpy( buf, pf, d );
    buf[d] = '\0';
    }
#endif

/* Fake out the arguments */
Argc  = *argc;
if (Argc == -1) {
    /* Recover the args with the Fortran routines iargc_ and getarg_ */
    Argc = iargc_() + 1;
    Argv = (char **)MALLOC( Argc * sizeof(char *) );     CHKPTR(Argv);
    for (i=0; i<Argc; i++) {
	Argv[i] = (char *)MALLOC( argsize + 1 );         CHKPTR(Argv[i]);
	getarg_( &i, Argv[i], argsize );
	/* Trim trailing blanks */
	p = Argv[i] + argsize - 1;
	while (p > Argv[i]) {
	    if (*p != ' ') {
		p[1] = '\0';
		break;
		}
	    p--;
	    }
	}
    }
#ifdef OLD_PICALL
PIcall( *np, (char **)0, buf, routine, Argc, Argv );
if (buf) FREE( buf );
#else
PICall( routine, Argc, Argv );
#endif

if (setargs) {
    for (i=0; i<=Argc; i++) 
	FREE( Argv[i] );
    FREE( Argv );
    }
}

