#ifndef lint
static char SCCSidI[] = "@(#) ./comm/initeui.c 07/23/93";
#endif

/*
    IBM-EUI specific routines.

    An assumption here is that the C-interface will be natural AND
    compatible with programs that also use Fortran.  If this is not
    true, a lot of routines will require parameters to be passed
    as addresses....
    
 */
int  __EUIFROM, __EUILEN, __EUITYPE;
int  __NUMNODES, __MYPROCID;
/*
    euiexitall - terminate all processes in an execution (parallel exit)
    See init.c for a complete description of the interface
 */
static void euiexitall(msg,rc)
char *msg;
int  rc;
{
if (msg) fprintf( stderr, msg );
mpc_stopall( rc );
}

#define PI_HAS_PIINIT
void PIinit()
{
mpc_environ( &__NUMNODES, &__MYPROCID );
PISetupCollectiveTree( );
PISetNbrRoutine( PIGetNbrsMSH );
}

#include <signal.h>

/*
   Horribly enough, this program needs to do a exec with the value of 
   MP_PROCS set to the value of -np.  Further, there is NO way to 
   select the nodes to use.

   Rumor has it that these restrictions will change.  We'll see...
 */
int PIcall( np, procgroup, pfname, routine, argc, argv )
int  np, argc;
char **procgroup, *pfname;
char **argv;
int  (*routine)();
{
int rc, fsec;

/* EUI seems to catch SIGINT, we catch rest here */
/* Reason: it seems SIGSEGV don't get passed back to host */
/*         so job may hang. We want parallel job to end by default */
/*         user may change in worker() routine */
SYSetDefaultSignals( (void (*)())0 );
/* EUI seems to send SIGTSTP, SIGCONT and SIGTTIN to nodes we want them ignored */
/* because when they receive SIGCONT or SIGTTIN they crash */
signal(SIGTSTP,SIG_IGN);
signal(SIGCONT,SIG_IGN);
/* This DOES NOT WORK; if host job is put in background and then keyboard used */
/* one gets process_io: stdin error: Interrupted system call */
/* they claim this was fixed in next release */
signal(SIGTTIN,SIG_IGN);

SYSetExitAll(euiexitall);
#if !defined(LOGCOMMDISABLE)
PIGetDebugArgs( &argc, argv );
#endif

/* Set resource limits */
SYGetResourceDefaults( &cpu, &mem, &pf, &niceval, &fsec );
/* Defaults are too small for SP so we do temporary ugly fix */
if (cpu == 120 && mem == 8 && fsec == 300) { cpu = 600; mem = 64;  fsec = 1200;}
SYGetDayTime( &maxtime ); maxtime.tv_sec += fsec;
SYGetResourceLimits( &argc, argv, &cpu, &mem, &pf, &maxtime, 1 );
SYSetResourceLimits( mem, cpu, pf, &maxtime );
if (niceval > 0) SYSetNice( niceval );

PIinit();
if (SYArgHasName( &argc, argv, 1, "-listnodes" )) {
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif
    char name[MAXHOSTNAMELEN];
    SYGetHostName( name, MAXHOSTNAMELEN );
    printf( "%s\n", name );
    }

PIinitlog();
rc = (*routine)( argc, argv );
PIendlog();
return rc;
}

/* Routine that can not easily be implemented as a macro */
int mppi_asyncprobe( type )
int type;
{
__EUITYPE = type;
__EUIFROM = DONTCARE;

/* mpc_probe( &__EUIFROM, &__EUITYPE, &__EUILEN );
return __EUILEN >= 0;	 */
euiexitall( "probe is not supported by EUI-1", 1);
}

#define PI_HAS_EXIT
#define PI_HAS_INIT




