#include "tools.h"
#include "system/system.h"
#include "comm/comm.h"
#include "comm/io/pio.h"
#include <math.h>

/* This is just example1.c, but changed to use 2 process sets */

main( argc, argv )
int  argc;
char **argv;
{
int worker();
PICall( worker, argc, argv );
}

int worker( argc, argv )
int  argc;
char **argv;
{
int         nx, ny, nr, nc, myid, ri, rj, i, j, g;
int         nxin, nyin, gin;
int         px, py;    /* Size of partition in each dimension */
PIFILE      *fp;
ProcSet     *ps;
PIArrayPart sz[2];
int         nd;
double      *v, *v2, voff;
double      t1, t2;
int         bytes;
char        filename[20];

/* get the global size */
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s -n nx -m ny -g n\n", argv[0] );
    return 0;
    }
nx = 16;
ny = 16;
g  = 0;
SYArgGetInt( &argc, argv, 1, "-n", &nx );
SYArgGetInt( &argc, argv, 1, "-m", &ny );
SYArgGetInt( &argc, argv, 1, "-g", &g );
if (SYArgHasName( &argc, argv, 1, "-block" ))
     PIFSetWritersBlock();

/* Create the two processor sets */
ps = PSPartition( PImytid % 2, PIAllProcs );
#ifdef FOO
for (i=0; i<=PInumtids; i++) {
    if (PIgtoken( PIAllProcs, i )) {
	printf( "Processor set for processor %d\n", PImytid );
	PSPrintProcset( ps, 0, stdout );
	PSPrintProcsetDetails( ps, stdout );
	}
    }
#endif
if ((PImytid % 2) == 0) {
    strcpy( filename, "foo.even" );
    voff = 0;
    }
else {
    strcpy( filename, "foo.odd" );
    voff = 100;
    }

fp = PIFopen( filename, ps, O_WRONLY | O_CREAT, PIO_AS_SEQUENTIAL );
PIWriteCommon( fp, "%4d",   4, &nx, 1, MSG_INT );
PIWriteCommon( fp, "%4d",   4, &ny, 1, MSG_INT );
PIWriteCommon( fp, "%4d\n", 5, &g,  1, MSG_INT );

nd   = 2;
nr   = PSnumtids(ps);
myid = PSmytid(ps);
/* printf( "[%d] local num = %d, rank = %d\n", PImytid, nr, myid ); */
if (nr > 1) 
    nr = sqrt( (double)nr + 0.1 );
nc = PSnumtids(ps) / nr;
if (nr * nc != PSnumtids(ps)) {
    fprintf( stderr, "Test only works for square arrays of processors\n" );
    return;
    }
ri = myid % nc;
rj = myid / nc;
    
px = nx / nc;
py = ny / nr;
/* printf( "[%d](%d,%d)\n", PImytid, ri, rj ); */
/* 
   The GLOBAL array is A(0:nx-1,0:ny-1).  The local array is
   declared as B(0:,0:), with B(g:,g:) matching A(ri*(nx/nc):,rj*(ny/nr):), 
   where the position of the processor in the mesh is given by (ri,rj)
 */
sz[0].mdim   = nx;
sz[0].ndim   = px + 2 * g;
sz[0].start  = g;
sz[0].end    = px - 1 + g;
sz[0].gstart = ri * px;
sz[0].gend   = sz[0].gstart + sz[0].ndim - 1;

sz[1].mdim   = ny;
sz[1].ndim   = py + 2 * g;
sz[1].start  = g;
sz[1].end    = py - 1 + g;
sz[1].gstart = rj * py;
sz[1].gend   = sz[1].gstart + sz[1].ndim - 1;
/* printf( "[%d]<%d,%d>\n", PImytid, sz[0].gstart, sz[1].gstart );  
fflush(stdout); */
v = (double *)MALLOC( sz[0].ndim * sz[1].ndim * sizeof(double) );  CHKPTR(v);
for (j=sz[1].start; j<=sz[1].end; j++) {
    for (i=sz[0].start; i<=sz[0].end; i++) {
	v[i + sz[0].ndim * j] = 
	    i + sz[0].gstart + (j + sz[1].gstart) * sz[0].mdim + voff;
	}
    }

PIgsync( ps );
t1 = SYGetElapsedTime();
PIWriteDistributedArray( fp, "%12.4e\n", 13, sz, nd, v, MSG_DBL );
PIgsync( ps );
t2 = SYGetElapsedTime() - t1;
if (PSISROOT(ps)) {
    bytes = 13 * nx * ny;
    printf( "Wrote %d bytes at %f Mbytes/second\n", bytes, bytes/(1.0e6*t2) );
    fflush( stdout );
    }
PIFclose( fp );

/* Now, try to READ the data back; check that it is correct */
fp = PIFopen( filename, ps, O_RDONLY, 0 );
if (!fp) {
    fprintf( stderr, "Can not open file for input\n" );
    return 0;
    }
v2 = (double *)MALLOC( sz[0].ndim * sz[1].ndim * sizeof(double) );  CHKPTR(v2);

PIReadCommon( fp, "%4d",   4, &nxin, 1, MSG_INT );
PIReadCommon( fp, "%4d",   4, &nyin, 1, MSG_INT );
PIReadCommon( fp, "%4d\n", 5, &gin,  1, MSG_INT );

PIgsync( ps );
t1 = SYGetElapsedTime();
PIReadDistributedArray( fp, "%12.4e\n", 13, sz, nd, v2, MSG_DBL );
PIgsync( ps );
t2 = SYGetElapsedTime() - t1;
if (PSISROOT(ps)) {
    bytes = 13 * nx * ny;
    printf( "Read %d bytes at %f Mbytes/second\n", bytes, bytes/(1.0e6*t2) );
    fflush( stdout );
    }
PIFclose( fp );

/* Check that the values are correct */
if (nxin != nx) 
    fprintf( stderr, "NX is inccorect in file\n" );
if (nyin != ny) 
    fprintf( stderr, "NY is inccorect in file\n" );
if (gin != g) 
    fprintf( stderr, "G is inccorect in file\n" );
    
for (j=sz[1].start; j<=sz[1].end; j++) {
    int k;
    for (i=sz[0].start; i<=sz[0].end; i++) {
	k = i + sz[0].ndim * j;
	if (v[k] != v2[k])
	    fprintf( stderr, 
		   "[%d]Error in V values in file in location %d (%e != %e)\n",
		     PImytid, k, v[k], v2[k] );
	}
    }


FREE( v );
FREE( v2 );
return 0;
}
