#ifndef lint
static char SCCSid[] = "@(#) ./comm/manyarch.c 11/08/92";
#endif

/* 
   This file contains routines to turn command line arguments into
   specifications for running on a hetergenous system.  The format is:

   [ -np nn [-arch name] [-exes name] [-hostname name[,name]*] ]*

   The result of this routine is a table of architectures that
   will need to be matched to available machines

 */

#include "tools.h"
#include "comm/comm.h"
#include "comm/hosts.h"

/* 
  Returns the number of selected architecture types

  This should replace the use of environment variables in initpvm.c
  (and initp4.c).  In particular, the change should include
  hosts.c (BuildHostTable) where the architectures are extracted
  from an environment variable.

  The form of the arguments here is

  -np <number of this architecture>
  -arch <name of this architecture>
  -exes <name of the executable>
  -hostname <name>[,<name>]*

  Eventually, the algorithm used by PICall will be:
  Create a host-table list
      Use PIGetArchTypes
      Fill in any gaps (missing hosts, architectures, ...)
  If necessary, get the resource limits

  Because the arguments are POSITIONAL, we need to process them positionally
 */
int PIGetArchTypes( Argc, argv, maxarches, np, arch, exes, hosts )
int  *Argc;
char **argv;
int  maxarches, np[];
int  arch[];
char **exes, **hosts;
{
int i, argc = *Argc, k;

i = 1;
k = 0;
while (i < argc && k < maxarches) {
    if (strcmp( argv[i], "-np" ) == 0) {
	np[k]   = atoi( argv[i+1] );
	argv[i] = argv[i+1] = 0;
	i       += 2;
	/* Set defaults? (currently, null means use "natural" value) */
        arch[k]  = 0;
	exes[k]  = 0;
	hosts[k] = 0;

	/* Get options */
	while (i < argc) {
	    if (strcmp( argv[i], "-arch" ) == 0) {
		arch[k] = PIToArch( argv[i+1] );
		argv[i] = argv[i+1] = 0;
		i       += 2;
		}
	    else if (strcmp( argv[i], "-exes" ) == 0) {
		exes[k] = argv[i+1];
		argv[i] = argv[i+1] = 0;
		i       += 2;
		}
	    else if (strcmp( argv[i], "-hostname" ) == 0) {
		hosts[k] = argv[i+1];
		argv[i]  = argv[i+1] = 0;
		i        += 2;
		}
	    else 
		break;
	    }
	k++;
	}
    else
	i++;
    }
SYArgStrip( Argc, argv );
return k;
}
