#ifndef lint
static char SCCSid[] = "@(#) ./comm/mfort.c 07/23/93";
#endif

/*
   This file contains Fortran interfaces for the communication routines
   and macros, for sends and receives.
*/

#include "comm.h"
#include "comm/procset.h"
#include <stdio.h>

#if defined(FORTRANCAPS)
#define recvfrom_       RECVFROM
#define recvlen_        RECVLEN
#define recvsyncnomem_  RECVSYNCNOMEM
#define sendsyncnomem_  SENDSYNCNOMEM
#elif !defined(FORTRANUNDERSCORE)
#define recvfrom_       recvfrom
#define recvlen_        recvlen
#define recvsyncnomem_  recvsyncnomem
#define sendsyncnomem_  sendsyncnomem
#endif

/* recvfrom is a system routine on the rs6000 */
#ifdef rs6000
#define recvfrom recvfromfv
#endif

int recvfrom_()
{
  return RECVFROM();
}

int recvlen_()
{
  return RECVLEN();
}

void recvsyncnomem_(type,buffer,length,datatype)
char *buffer;
int  *type,*length,*datatype;
{
  RECVSYNCNOMEM(*type,buffer,*length,*datatype);
}

void sendsyncnomem_(type,buffer,length,to,datatype)
char *buffer;
int  *type,*length,*datatype,*to;
{
  int dt;
#if defined(pvm)
  dt = *datatype + 1; 
#elif defined(p4)
  dt = *datatype + 1;
  if (dt == 5) dt = 0;
#else
  dt = 0;
#endif
  SENDSYNCNOMEM(*type,buffer,*length,*to,dt);
}

