#ifndef LINT
static char SCCSid[] = "@(#) ./comm/save/p4pgm.c 07/23/93";
#endif

#include <stdio.h>
#include <time.h>
#include <sys/param.h>
/* 
  From sys/param.h:
 x #define	MAXPATHLEN	1024
 x #define	MAXHOSTNAMELEN  64
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/* D
     p4pgm - produce a p4 procgroup file on standard output, given a 
     requested number of processors and an architecture.  Later, we'll
     allow cpu and memory limits to be specified.

     Options:
.     -np n       Number of processors
.     -arch name  Architecture name
.     -exes name  Name of program (fully qualified)
.     -cpu  min   minutes of cpu time
.     -mem  mb    megabytes of memory
.     -pf   n     number of pagefaults
.     -dbg        write out the decision process (debugging)
D */
main( argc, argv )
int  argc;
char **argv;
{
FILE *fin, *fout;
int  np, cpu, mem, pf, dbg;
char arch[20];
char pname[MAXPATHLEN];

PIArgsToResources( &argc, argv, &np, &cpu, &mem, &pf, &dbg, arch, pname );

argv++;
while (--argc) {
    if (strcmp( "-help", argv[0]) == 0) {
	fprintf( stderr, "p4pgm -arch name -np n -exes name\n" );
        exit(0);
        }
    else {
        fprintf( stderr, "Unrecognized arg %s\n", argv[0] );
        exit(1);
        }
    argv++;
    }

fin = fopen( "/home/gropp/tools/comm/hosts", "r" );
if (!fin) {
    fprintf( stderr, "Can not open hosts file\n" );
    exit(1);
    }
PIbuildP4PG( np, fin, stdout, arch, pname, mem, cpu, pf, dbg );
}
