/*
   Macros and structure for set operations
 */
#ifndef SETBIT

typedef struct {
    int           nb, nw;
    unsigned long b[1];
    } Set;
extern unsigned long __SYmask[32];

#define SETBIT(s,bb) {(s)->b[(bb)>>5] |= __SYmask[(bb)&0x1f];}
#define CLRBIT(s,bb) {(s)->b[(bb)>>5] &= ~__SYmask[(bb)&0x1f];}
#define ISSET(s,bb)  ((s)->b[(bb)>>5] & __SYmask[(bb)&0x1f]) 
#endif
