/*
   This is a test program for the gmres solver.  We use the basic "vector"
   ops in vectors
 */

#include <stdio.h>
#define RERROR  gmres_error
#include "tools.h"
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/gmresctx.h"
#include "vectors/vector.h"
#include <math.h>

static void amult();
static void binv();

/*ARGSUSED*/
int main( argc, argv )
int  argc;
char **argv;
{
ITCntx   *itP;
int      gmres_k, n, *np;
double   *soln, *rhs;

gmres_k = 20;
np      = &n;
itP = ITCreate(ITGMRES);
ITGMRESSetDirections( itP, gmres_k );
DVSetDefaultFunctions( ITVectorCtx( itP ) );

n       = 100;   /* size of each vector */
/* Setup the user's private data structures */
soln = (double *)MALLOC( (unsigned)(n * sizeof(double)) );
rhs  = (double *)MALLOC( (unsigned)(n * sizeof(double)) );
ITSetRhs( itP, rhs );
ITSetSolution( itP, soln );

ITSetAmult(itP,amult);
ITSetBinv(itP,binv);

ITSetUp(itP,np);

/* set the rhs and the initial solution */
DVset( (VEDefaultUsrCntx*)np, 1.0, rhs );
DVset( (VEDefaultUsrCntx*)np, 0.0, soln );

ITSolve(itP,np);
ITDestroy(itP,np);
return 0;
}

PrintResidual( itP, np, soln, rhs, v1, v2 )
ITCntx *itP;
int       *np;
double    *soln, *rhs, *v1, *v2;
{
double res,dot;
int    n = *np;

/* Check on ACTUAL residual */
amult( np, soln, v1 );
DVcopy( (VEDefaultUsrCntx*)np, rhs, v1 );
DVaxpy( (VEDefaultUsrCntx*)np, -1.0, v1, v2 );         /* f - a*x into temp */
DVdot(  (VEDefaultUsrCntx*)np, v2, v2, &dot );
res   = sqrt( dot  );
printf( "Actual residual is %e\n", res );
}

/* This amult is for the discrete laplacian in 1-d */
static void amult( np, v1, v2 )
int     *np;
double  *v1, *v2;
{
double *p1, *p2;
int    n = *np;

p1   = v1;
p2   = v2;
*p2++= 2* *p1 - *(p1+1);
p1++;
n--;
n--;
while (n--) {
    *p2++ = 2.0 * *p1 - *(p1-1) - *(p1+1);
    p1++;
    }
*p2++= 2.0 * *p1 - *(p1-1);
}

static void binv( np, v1, v2 )
int     *np;
double  *v1, *v2;
{
DVcopy( (VEDefaultUsrCntx*)np, v1, v2 );
}


