#ifndef lint
static char SCCSid[] = "@(#) ./iter/gmres/borthog.c 07/23/93";
#endif

#define ITCOUNT it
#define IT it
#define RERROR  gmres_error
#include "tools.h"
#include "iter/itctx.h"
#include "iter/itpriv.h"
#include "iter/gmresctx.h"
#include "gmresp.h"

/*
  This is the basic version and does not assume anything. 
 */
int GMRESBasicOrthog( usrP, itP, it )
void         *usrP;
int          it;
ITCntx    *itP;
{
ITGMRESCntx *gmresP = (ITGMRESCntx *)(itP->MethodPrivate);
int    j;
double *hh, *hes;

/* update hessenberg matrix and do Gram-Schmidt */
hh  = HH(0,it);
hes = HES(0,it);
for (j=0; j<=it; j++) {
    /* vv(j) . vv(it+1) */
    DOT( VEC_VV(j), VEC_VV(it+1), hh );
    *hes++   = *hh;
    /* vv(j) <- vv(j) - hh[j][it] vv(it) */
    DAXPY( - (*hh++), VEC_VV(j), VEC_VV(it+1) );
    }
return 0;
}
