/*
    @(#) ./iter/gmresctx.h 07/23/93
    Context for a GMRES iteration.  From this, the common iterative 
    data structure, and the user-defined
    distributed data structure, the GMRES iterations may be computed.
 */

#if !defined(__GMRES)
#define __GMRES

typedef struct {
    /* Hessenberg matrix and orthogonalization information.  Hes holds
       the original (unmodified) hessenberg matrix which may be used
       to estimate the eigenvalues of the matrix */
    double *hh_origin, *hes_origin, *cc_origin, *ss_origin, *rs_origin;

    /* parameters */
    double haptol, epsabs;         /* */
    int    max_k;

    /* Functions to use (special to gmres) */
    int   (*orthog)();
    
    /* vecs holds the temporary vectors */
    void   **vecs;
    /* vv_allocated is the number of allocated gmres direction vectors */
    int    q_preallocate, delta_allocate;
    int    vv_allocated;
    /* vecs_allocated is the total number of vecs available (used to 
       simplify the dynamic allocation of vectors */
    int    vecs_allocated;
    /* Since we may call the user "obtain_work_vectors" several times, 
       we have to keep track of the pointers that it has returned 
       (so that we may free the storage) */
    void   ***user_work;
    int    *mwork_alloc;    /* Number of work vectors allocated as part of
			       a work-vector chunck */
    int    nwork_alloc;     /* Number of work vectors allocated */

    /* In order to allow the solution to be constructed during the solution
       process, we need some additional information: */
    int    it;              /* Current iteration */
    double *nrs;            /* temp that holds the coefficients of the 
			       Krylov vectors that form the minimum residual
			       solution */
    void   *sol_temp;       /* used to hold temporary solution */
    } ITGMRESCntx;


#endif
