/*
        @(#) ./nonlin/nlctx.h 07/23/93
	Context variable used by all the Nonlinear Solvers.
 */

#ifndef __NLCONTEXT
#define __NLCONTEXT
#include <stdio.h>
#include "tools.h"
#include "vectors/vector.h"

/* 
   Known methods
 */
typedef enum { NLNEWTONTR, NLNEWTONLS, NLNEWTONTR2 } NLMETHOD;

/*
   Nonlinear solver context
 */
typedef struct {
  /*------------------------- User parameters--------------------------*/
  int max_it,                      /* maximum number of iterations */
      max_func;                    /* maximum number of function evaluations */

  double ftol,                     /* function tolerance */
         xtol;                     /* tolerance in solution */

  double trunctol;                 /* tolerance for linear solves*/
  void *vec_sol;                   /* pointer to where user wants solution 
                                      these are never touched by the code,
                                      only passed back to the user */ 
  double *residual_history;        /* If !0 stores residual at iterations*/
  FILE *fp;                        /* file to dump trace info */

  /* --------User (or default) routines ------------------------------*/
  void (*usr_monitor)();           /* returns control to user after residual
                                      calculation, allows user to, for 
                                      instance, print residual norm, etc. */
  int (*converged)();
  void (*initial_guess)();         /* calculates an initial guess */
  VECntx *vc;                      /* Vector routines */
  void (*fun)();                   /* evaluates function*/
  void (*stepSetup)(),             /* Compute a step.  Often, these will */
       (*stepCompute)(),           /* involve the inverse of the Jacobian */
       (*stepDestroy)();
  void *stepCtx;                   /* Local context for the step routines */

/*------------ Major routines which act on NLcontext-----------------*/
  NLMETHOD  method;                /* type of solver */
  int  (*solver)();                /* actual solver */
  void (*setup)();
  void (*destroy)();
  void *MethodPrivate;             /* holder for misc stuff associated 
                                      with a particular method */

  /* ----------------Default work-area management -------------------- */
  int  nwork;
  void **work;

  /* ----------------Keep track of the amount of work----------------- */
  int  nfunc, nsteps, nvectors, nscalar;
} NLCntx;

#endif


