/*
       These are some routines needed for the incomplete LU
   preconditioner.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include <math.h>

/*ARGSUSED*/
void SViCreateILU(ctx,mat)
SVctx *ctx;
SpMat *mat;
{
  SVILUctx *lctx;
  lctx = NEW(SVILUctx); CHKPTR(lctx);
  lctx->fill = 0;
  lctx->rtol = -1.0;
  lctx->pivoting = PIVOT_NONE;

  ctx->method = ITGMRES;
  ctx->private = (void *) lctx;
  ctx->is_iter = 1;

  ctx->setup   = SViSetupILU;
  ctx->solve   = SViSolveILU;
  ctx->destroy = SViDestroyILU;
}
/*------------------------------------------------------------------*/
void SViSetupILU(ctx)
SVctx *ctx;
{
  SVILUctx *lctx = (SVILUctx *) ctx->private;
  int       i,n = ctx->size;
  int *cperm=0, *iperm, *rperm, *irperm;
  double atol = 0.0;     /* Drop only exactly zero diagonal elements */
  double      t1;

  t1 = SYGetCPUTime();
  TRPUSH(1001);
  TRPUSH(1003);
  ctx->itctx = ITCreate(ctx->method);    CHKERR(1);
  DVSetDefaultFunctions(ctx->itctx->vc); CHKERR(1);
  TRPOP;
  ctx->itctx->amult = SViMult;
  ctx->itctx->tamult= SViMultTrans;
  ctx->itctx->binv  = SViApplyILUPreconditioner;
  /* put dummy values in vec_sol and vec_rhs */
  ctx->itctx->vec_sol = (void *) 1;
  ctx->itctx->vec_rhs = (void *) 1;
  ctx->itctx->usr_monitor = 0;

  lctx->split = SpCreateSplit( ctx->mat, 0 ); CHKERR(1);
  if (lctx->pivoting == PIVOT_PRE_SYM || lctx->pivoting == PIVOT_PRE_NONSYM) {
      cperm  = (int *)MALLOC( n*sizeof(int) );   CHKPTR(cperm);
      iperm  = (int *)MALLOC( n*sizeof(int) );   CHKPTR(iperm);
      rperm  = (int *)MALLOC( n*sizeof(int) );   CHKPTR(rperm);
      irperm = (int *)MALLOC( n*sizeof(int) );   CHKPTR(irperm);
      for ( i=0; i<n; i++ ) {rperm[i] = cperm[i] = i;}
      switch (lctx->pivoting) {
	  case PIVOT_PRE_SYM:
          SpSymmetricReorderForZeroDiagonal( ctx->mat, atol, rperm, cperm );
	  break;
	  case PIVOT_PRE_NONSYM:
          SpUnSymmetricReorderForZeroDiagonal( ctx->mat, atol, rperm, cperm );
	  break;
	  }
      SpInverse( n, cperm, iperm );
      /* SpInverse( n, rperm, irperm ); */

      SpiSetMappingPtrs( lctx->split->factor, rperm, iperm, cperm ); 
      /* SpiSetMappingPtrs( lctx->split->factor, rperm, cperm, iperm ); */
      FREE(irperm);
      }
  
  if (lctx->rtol > 0) 
      SpComputeILUND( ctx->mat, lctx->split, lctx->rtol, 0.0, lctx->fill );
  else {
      if (lctx->fill > 0) {
	  TRPUSH(1002);
	  if (lctx->split->factor->map) 
	      SpComputeILUFill( ctx->mat, lctx->split, lctx->fill ); 
	  else
	      SpComputeILUFillNoMap( ctx->mat, lctx->split, lctx->fill ); 
	  TRPOP;
	  }
      else
	  SpCopyStructure( ctx->mat, lctx->split );
      CHKERR(1);
      SpComputeFactor( ctx->mat, lctx->split ); CHKERR(1);
      /* printf( "Factored matrix\n" );
      SpPrintAsDense( stdout, lctx->split->factor ); */
      }

  ctx->flops  = SpCostFactor(lctx->split);
  ctx->memory = SpGetSpaceUsed(lctx->split);
  ctx->nz     = SpNz(lctx->split);
  ctx->nzorig = SpNz(ctx->mat);
  ctx->setupcalled = 1;
  ctx->t_setup += SYGetCPUTime() - t1;
  TRPOP;
}
/*------------------------------------------------------------------*/
int SViSolveILU(ctx,b,x)
SVctx   *ctx;
double  *b,*x;
{
  int      its;
  double   t1;
  if (!ctx->setupcalled) (*ctx->setup)(ctx); CHKERRV(1,-1);
  if (!ctx->solvecalled) {
      t1   = SYGetCPUTime();
      ITSetUp(ctx->itctx,(void *) ctx); CHKERRV(1,-1);
      ctx->t_setup += SYGetCPUTime() - t1;
      }
  ctx->solvecalled = 1;

  t1 = SYGetCPUTime();
  SViManageInitialGuess( ctx, x );
  ctx->itctx->vec_rhs = (void *) b;
  ctx->itctx->vec_sol = (void *) x;
  its = ITSolve(ctx->itctx,(void *) ctx);
  SVGetITFlops(ctx,2*ctx->nzorig,2*ctx->nz);
  ctx->its = its;
  ctx->t_solve += SYGetCPUTime() - t1;
  return its;
}
/*------------------------------------------------------------------*/
void SViDestroyILU(ctx)
SVctx *ctx;
{
  SVILUctx *lctx = (SVILUctx *) ctx->private;
  VEDestroy(ctx->itctx->vc);
  ITDestroy(ctx->itctx,ctx);
  SpDestroySplit(lctx->split); FREE(ctx->private); FREE(ctx);
}
/*------------------------------------------------------------------*/
/*
   SViApplyILU - Applies the ILU preconditioner to a dense vector, the matrix
   is hidden in the SVctx. 
 */

void SViApplyILUPreconditioner(ctx,x,y)
SVctx  *ctx;
double *x,*y;
{
ctx->nbinv++;

SpSolve(((SVILUctx *)ctx->private)->split,x,y);
}
