#ifndef lint
static char SCCSid[] = "@(#) ./solvers/svcvt.c 07/23/93";
#endif

/*
    This file contains routines to convert matrix formats to ones
    that are (it is to be hoped) more efficient for operations involved
    in iterative methods.

    There are many such optimizations that can be made.  To start with,
    we'll convert from row to aij format.  ija is another option to
    consider.

    Another issue is whether Fortran or C routines should be used to
    implement the "optimized" routines.  Note that the static datastructures
    of these data formats reduces indirect memory accesses as well as
    paging (since data is relatively consequetive in memory).

    Unanswered question:
    Is a "replaced" matrix freed?  How does the user free any matrix
    generated here?  Does SVDestroy do it?  How does the user know if
    the input matrices can be freed?

    One choice is for this code to free any matrices that it replaces
    (based on an input parameter); further, a field in svctx remembers
    whether a matrix was generated internally.

    Another issue is how to propagate this into methods that may have
    their own local matrices and operations.  Also there is the issue
    of propagating this into methods that themselves use solvers.  For
    this, we probably need a way to walk down the tree of solvers contexts,
    hitting all of the entries.

 */

#include "tools.h"
#include "solvers/svctx.h"
#include "sparse/sppriv.h"

SpMat *SViCVTToAIJ(); 

void SVCvtMatrixFormat( ctx )
SVctx *ctx;
{    
int amatismat; 
if (ctx->type == SVLU) return;
/* perhaps we should convert the factored form in case multiple RHS's
   are being solved (as for subdomain solves inside an iterative method) */

/* AMult */
amatismat = ctx->amat == ctx->mat;
if (ctx->amat->type == MATROW) {
    ctx->amat = SViCVTToAIJ( ctx->amat );
    /* Need to remember that we've done this */
    if (!ctx->amat) {
	SETERRC( 1, "Could not convert A matrix in solver context" );
	}
    }    
if (! amatismat && ctx->mat->type == MATROW) {
    }
}

/*
    To convert to AIJ,  we could use ToAIJ, then SpAIJCreateFromData()
 */
SpMat *SViCVTToAIJ( mat )
SpMat *mat;
{
int     nz, *ia, *ja, err;
double  *a;

nz = SpNz( mat );
ia = (int *)MALLOC( (mat->rows + 1 + nz) * sizeof(int) );  CHKPTRN(ia);
ja = ia + (mat->rows + 1);
a  = (double *)MALLOC( nz * sizeof(double) );              CHKPTRN(a);
if (err = SpToAIJ( mat, ia, ja, a, nz )) {
    char buf[100];
    sprintf( buf, 
"Need %d more words (%d total) while converting matrix format", err, nz+err );
    SETERRC(1,buf);
    FREE( ia );
    FREE( a );
    return 0;
    }
return SpAIJCreateFromData( mat->rows, mat->cols, ia, ja, a, nz );
}
