#ifndef lint
static char SCCSid[] = "@(#) ./sparse/add.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
    SpAdd - Add one matrix to another.

    Input parameters:
.    mat1  - matrix to add to
.    mat2  - matrix to add from

    Notes:  
    By add, we mean add.  Entries will be summed into the matrix.
    The size of the matrix may be expanded.
 @*/
void SpAdd( mat1, mat2 )
SpMat *mat1, *mat2;
{
int      r2, r, nz2, *i2;
double   *v2;

SPLITTOMAT(mat1);
SPLITTOMAT(mat2);
r2 = mat1->rows;
for (r=0; r<r2; r++) {
    SpScatterFromRow( mat2, r, &nz2, &i2, &v2 );
    if (nz2 > 0) 
	SpGatherAddToRow( mat1, r, nz2, i2, v2 );              CHKERR(0);
    }
}
