#ifndef lint
static char SCCSid[] = "@(#) ./sparse/default/dfcreate.c 07/23/93";
#endif

/*
   This file contains routines to generate an SpOps structure, initialized
   with the default routines.
 */
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

extern void SpDfMult(), SpDfMultAdd(), SpDfMultTrans(), SpDfSolve(), 
            SpDfSolveTrans();
extern int  SpDfComputeFill(), SpDfComputeFactor();
extern SpMatSplit *SpDfCreateSplit();

/* @
   SpDfCreateSpOps - Create a sparse matrix operations structure and
   fill it with the default operations

   Returns:
   Sparse matrix operations structure.

   Notes:
   This routine should be used when defining new sparse matrix formats.
   This insures that all operations are defined in terms of
   SpScatterFromRow and SpGatherToRow.

   The default implementations are not intended to be optimally efficient.
   They simply relieve the programmer from the burden of defining all of the
   operations when defining a new sparse matrix format.  Profiling data should
   be used to determine which operations need to be optimized for a specific
   format.
@ */
SpOps *SpDfCreateSpOps()
{
SpOps *new;

new = NEW(SpOps);

/* Clear all entries ( relies on null pointers being 0) */
MEMSET( new, 0, sizeof(SpOps) );

/* Set all entries (but the irreducible minimum) to the default operations */
new->mv              = SpDfMult;
new->mvpv            = SpDfMultAdd;
new->mtv             = SpDfMultTrans;
new->solve           = SpDfSolve;
new->solveTranspose  = SpDfSolveTrans;
new->TsolveRelaxL    = /* SpDfTsolveL; */ 0;
new->TsolveRelaxU    = /* SpDfTsolveU; */ 0;
new->destroy         = 0;  /* Must be supplied */
new->create          = 0;  /* Must be supplied */
new->createsplit     = (void *(*)())SpDfCreateSplit;
new->incompleteFill  = 0; 
new->fill            = SpDfComputeFill;
new->factor          = SpDfComputeFactor; 
new->subset          = 0;
new->subsetrows      = 0;
new->gathertorow     = 0;  /* Must be supplied */
new->gatheraddtorow  = 0;  /* Must be supplied */
new->scatterfromrow  = 0;  /* Must be supplied */
new->lowersize       = 0;
new->mm              = 0;
new->ScatterGivesCols = 0; /* Must be supplied */
new->ScatterGivesVals = 0; /* Must be supplied */
new->ColOffset        = 0; /* Must be supplied */

return new;
}


SpMatSplit *SpDfCreateSplit( model, nmax )
SpMat *model;
int   nmax;
{
int  n = model->rows, m = model->cols;
SpMatSplit *mat;

TRPUSH(SPTRID + TRIDCREATE + 1);
mat         = NEW(SpMatSplit);  CHKPTRV(mat,0);
mat->type   = MATSPLIT;
mat->factor = SpCreate( n, m, 0 ); CHKERRV(mat->factor,0);
mat->nzl    = (int *) MALLOC( n*sizeof(int) ); CHKPTRV(mat->nzl,0);
TRPOP;
return mat;
}
