#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/diag/sp2diag.c 07/23/93";
#endif

/* 
   This file contains a simple routine to change from SpRow format to
   diagonal format, for matrices that have a regular diagonal structure.
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "sparse/diag/diag.h"

/*@
   SpDFromSpR - generate a copy of a matrix in diagonal format, using a
                pattern of rows

   Input parameters:
.  mat - matrix to copy
.  n   - number of elements in pattern
.  pattern - an array containing the number of rows in each block.
   
   Returns:
   Pointer to copy of matrix.

   Notes:
   This routine takes pattern[i mod n] rows from mat and tries to
   form them into a diagonal block.  For example, for the 5-point
   laplacian on a 2-d mesh (size m x m), the appropriate values are
   n = 3, pattern[] = { 1, m-2, 1 }.
@*/
SpMat *SpDFromSpR( mat, n, pattern )
SpMat *mat;
int   n, pattern[];
{
SpMat     *nmat;
SpMatDiag *dmat;
int       row, cycle, blks, i, cnt, nd, len, r, j, nz;
SpVec     *mrow;
SpRowMat  *R;
double    *v;
int       nrows = mat->rows;
int       *diag;

blks = 0;
for (i=0; i<n; i++) 
    blks += pattern[i];
if ((nrows % blks) == 0) blks = n * (nrows / blks);
/* else ??? */

R = GETROWMAT( mat );
    
nmat = SpDCreate( nrows, nrows, blks );
dmat = (SpMatDiag *)nmat->data;
row   = 0;
cycle = 0;
cnt   = 0;
while (row < nrows) {
    /* Compute the number of diagonals */
    mrow = R->rs[row];
    nd   = mrow->nz;
    len  = pattern[cycle];
    /* for the first pass, don't optimize for constant diagonals */
    dmat->sd[cnt] = SpDAllocateBlock( row, len, 1, 1, nd, 
				      DIAG_UNITSTRIDE );
    
    /* Set the values.  Screech if an out-of-band value is found */

    /* Compute the diagonal values from the first row */
    diag = dmat->sd[cnt]->doff;
    for (i=0; i<nd; i++) 
	diag[i] = mrow->i[i] - row;
    /* dmat->sd[cnt]->v = (double **)MALLOC( nd * sizeof(double *) );   */
    /* CHKPTRN(dmat->sd[cnt]->v); */
    for (i=0; i<nd; i++)
	dmat->sd[cnt]->v[i] = (double *)MALLOC( len * sizeof(double) );
    for (r=row; r<row+len; r++) {
	mrow = R->rs[r];
	nz   = mrow->nz;
	if (nz != nd) {
	    SETERRC(1,"Mismatch in number of diagonals");
	    break;
	    }
	for (j=0; j<nz; j++) {
	    dmat->sd[cnt]->v[j][r-row] = mrow->v[j];
	    if (mrow->i[j] - r != diag[j]) {
		SETERRC(2,"Mismatch in diagonal entries");
		break;
		}
	    }
	}
    row = r;
    cycle++;
    if (cycle >= n) cycle = 0;
    cnt++;
    }

return nmat;
}
