/* @(#) ./sparse/fblock/spfbpriv.h 07/23/93 */

#ifndef __SPFBpriv
/*
   Private structures for the sparse matrix routines.  These are
   only for the block routines.  This version is optimized for
   fixed-sized blocks that are a statically allocated.

   All blocks are the same size (bsize x bsize).

   One question is whether we store a collection of contiguous blocks for each
   row; this could improve the performance of the operations by reducing the
   number of copies / calls to BLAS (an alternate is to copy into a work
   vector and then copy out; this is to be avoided if possible because of the
   move acomplishes no useful work).
 */   
typedef struct {
    int    nz,      /* number of non-zero blocks */
           maxn,    /* allocated size */
           dloc,    /* location of diagonal */
           *i;      /* column indices */
    double *v; 
    } SpFBVec;

/* Row-oriented structure with optional hierarchy */
typedef struct {
    SpFBVec    **rs;
    int        bsize;     /* Size of blocks */
    int        *ioff;     /* Offsets (column values * blocksize) */
    int        nfbvecs;   /* number of SpFBVec; should be mat->rows / bsize */
         /* Do I want to save this here, or put it somewhere else?
            I'm exchanging an integer multiply for a shift, add, lookup,
            which may not be faster except on SPARCs */
    } SpFBRowMat;

/* Get the rowmat structure from a mat */
#define GETBROWMAT(a) ((SpFBRowMat *)((a)->data))

/* Additionally, it would be nice to know if the "blocks" are stored 
   contiguously along a row */


/* Things to move to spmat.h when block is added */
extern SpMat *SpFBCreate();


#endif
