C----- SUBROUTINE GENRCM
C***************************************************************           1.
C***************************************************************           2.
C********   GENRCM ..... GENERAL REVERSE CUTHILL MCKEE   *******           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - GENRCM FINDS THE REVERSE CUTHILL-MCKEE                     7.
C        ORDERING FOR A GENERAL GRAPH. FOR EACH CONNECTED                  8.
C        COMPONENT IN THE GRAPH, GENRCM OBTAINS THE ORDERING               9.
C        BY CALLING THE SUBROUTINE RCM.                                   10.
C                                                                         11.
C     INPUT PARAMETERS -                                                  12.
C        NEQNS - NUMBER OF EQUATIONS                                      13.
C        (XADJ, ADJNCY) - ARRAY PAIR CONTAINING THE ADJACENCY             14.
C               STRUCTURE OF THE GRAPH OF THE MATRIX.                     15.
C                                                                         16.
C     OUTPUT PARAMETER -                                                  17.
C        PERM - VECTOR THAT CONTAINS THE RCM ORDERING.                    18.
C                                                                         19.
C     WORKING PARAMETERS -                                                20.
C        MASK - IS USED TO MARK VARIABLES THAT HAVE BEEN                  21.
C               NUMBERED DURING THE ORDERING PROCESS. IT IS               22.
C               INITIALIZED TO 1, AND SET TO ZERO AS EACH NODE            23.
C               IS NUMBERED.                                              24.
C        XLS - THE INDEX VECTOR FOR A LEVEL STRUCTURE.  THE               25.
C               LEVEL STRUCTURE IS STORED IN THE CURRENTLY                26.
C               UNUSED SPACES IN THE PERMUTATION VECTOR PERM.             27.
C                                                                         28.
C     PROGRAM SUBROUTINES -                                               29.
C        FNROOT, RCM.                                                     30.
C                                                                         31.
C***************************************************************          32.
C                                                                         33.
      SUBROUTINE  GENRCM ( NEQNS, XADJ, ADJNCY, PERM, MASK, XLS )         34.
C                                                                         35.
C***************************************************************          36.
C                                                                         37.
         INTEGER ADJNCY(1), MASK(1), PERM(1), XLS(1)                      38.
         INTEGER XADJ(1), CCSIZE, I, NEQNS, NLVL,                         39.
     1           NUM, ROOT                                                40.
C                                                                         41.
C***************************************************************          42.
C                                                                         43.
         DO 100 I = 1, NEQNS                                              44.
            MASK(I) = 1                                                   45.
  100    CONTINUE                                                         46.
         NUM = 1                                                          47.
         DO 200 I = 1, NEQNS                                              48.
C           ---------------------------------------                       49.
C           FOR EACH MASKED CONNECTED COMPONENT ...                       50.
C           ---------------------------------------                       51.
            IF (MASK(I) .EQ. 0) GO TO 200                                 52.
               ROOT = I                                                   53.
C              -----------------------------------------                  54.
C              FIRST FIND A PSEUDO-PERIPHERAL NODE ROOT.                  55.
C              NOTE THAT THE LEVEL STRUCTURE FOUND BY                     56.
C              FNROOT IS STORED STARTING AT PERM(NUM).                    57.
C              THEN RCM IS CALLED TO ORDER THE COMPONENT                  58.
C              USING ROOT AS THE STARTING NODE.                           59.
C              -----------------------------------------                  60.
               CALL  FNROOT ( ROOT, XADJ, ADJNCY, MASK,                   61.
     1                        NLVL, XLS, PERM(NUM) )                      62.
               CALL     RCM ( ROOT, XADJ, ADJNCY, MASK,                   63.
     1                        PERM(NUM), CCSIZE, XLS )                    64.
               NUM = NUM + CCSIZE                                         65.
               IF (NUM .GT. NEQNS) RETURN                                 66.
  200    CONTINUE                                                         67.
         RETURN                                                           68.
      END                                                                 69.
