#ifndef lint
static char SCCSid[] = "@(#) ./sparse/setrow.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

void SpSetValue(), SpiInsertValue();

/*
   Changes to these routines:

   If column indices are sorted, we can do:
   
 */

/*
    SpSetInRowSorted - Sets a row in a sparse matrix. Untested.

    Input parameters:
.    mat   - matrix to set row to
.    row   - row index
.    n     - number of values to set
.    v     - values
.    c     - columns corresponding to columns.  These MUST be in increasing
            order.

    Returns: 
    Error value

    Notes:
    This is untested; I've just transfered this from paper to this file.
    Possible problems (besides the usual off-by-one errors): Allocation
    code not present, linear search for elements may be slow
 */
#ifdef FOO
int SpSetInRowSorted( mat, row, n, v, c )    
SpMat  *mat;
int    row, n, *c;
double *v;
{
SpRowMat *R;
SpVec    *x;
int      nzx, nz, i, j, *ix, k, *ixn;
double   *vx, *vxn;

/* We should really use a threshold test: if n < INSERT_THRESHOLD, just
   use a loop on the insert-single-element routine.  INSERT_THRESHOLD
   will probably be 1 unless we also look at the length of the vector */

SPLITTOMAT(mat);
R   = GETROWMAT(mat);
x   = R->rs[row]; 
nzx = x->nz;
ix  = x->i;

/* Try to arrange this so that the special case of the existing row is
   empty takes little time (either test for or make sure code doesn't
   spend a lot of time on empty comparisons) */

/* First, determine the size of the resulting row (count the number of
   inserts). Note that if we could overwrite c, we could replace the
   actual columns with the positions in the new array (or we could
   use a temp index array).  A similar thing could be done with ix
   to make the part of this code that does a SET into a SCATTER. 
 */
j  = 0;
nz = nzx;
for (i=0; i<n; i++) {
    if (j > nzx) {
	nz += (n - i);
	break;
	}
    if (ix[j] < c[i]) j++;
    else if (ix[j] > c[i]) nz++;
    }

/* Allocate new space if necessary */
if (nz > nzx) {
    ;
    }

/* Merge the two rows together */
i  = 0; 
j  = 0;
while (i < n && j < nzx) {
    if (c[i] <= ix[j]) {
	ixn[k] = c[i];
	vxn[k] = v[i];
	i++;
	if (c[i] == ix[j]) j++;
	}
    else {
	ixn[k] = ix[j];
	vxn[k] = vx[j];
	j++;
	}
    k++;
    }
return ERR_NONE;
}
#endif

/*@
    SpSetInRow - Sets a row in a sparse matrix.

    Input parameters:
.    mat   - matrix to set row to
.    row   - row index
.    n     - number of values to set
.    v     - values
.    c     - columns corresponding to columns.  These MUST be in increasing
            order.
 @*/
void SpSetInRow( mat, row, n, v, c )    
SpMat  *mat;
int    row, n;
register int    *c;
register double *v;
{
SpRowMat *R;
SpVec    *x;
int      nzx;
register int      m, *Ix, N=n;
register double   *Px;

/* Early implementation.  Better implementations could do multiple 
   inserts (row at a time).  We do handle the important case of adding to an
   empty row in the matrix. */
SPLITTOMAT(mat);
R   = GETROWMAT(mat);
x   = R->rs[row]; 
nzx = x->nz;
if (nzx == 0) {
    if (x->maxn > 0 && x->maxn < N) {
	SPFreeNV( mat, x->maxn, x->v, x->i );
	x->maxn = 0;
	}
    if (x->maxn < N)  {
	SPMallocNV( mat, N, &(x->v), &(x->i) ); CHKERR(0);
	x->maxn = N;
	}
    x->nz = N;
    Px    = x->v;
    Ix    = x->i;
    /* It may be better to split this loop on some machines */
    for (m=0; m<N; m++) {
	Px[m] = v[m];
	Ix[m] = c[m];
	}
    }
else {
    while (N--) {
	SpSetValue( mat, *v++, row, *c++ ); CHKERR(1);}
    }
}

/*@
   SpSetValue - set an entry in a matrix.  If the entry is not present,
                   create it.

   Input Parameters:
.   mat - matrix to set value to 
.   val - actual value
.   i,j - row i and column j
@*/
void SpSetValue( mat, val, i, j )
SpMat *mat;
double       val;
int          i, j;
{
SpRowMat *R;
SpVec    *x;
int      nzx, *ix, k, a, b, t;

SPLITTOMAT(mat);
R   = GETROWMAT(mat);
x   = R->rs[i]; 
nzx = x->nz;
ix  = x->i;

/* Find location for value.  */
a = 0; 
b = nzx;    /* b is one greater */
#define PRESORT
#ifdef PRESORT
while (b-a > 5) {
    t = (b+a)/2;
    if (ix[t] > j)
	b = t;
    else
	a = t;
    }
#endif
ix = ix + a;
for (k=a; k<b; k++) {
    if (*ix >= j) {
	if (*ix == j) {
	    x->v[k] = val;
	    return;
	    }
	break;
	}
    ix++;
    }
SpiInsertValue( mat, x, j, val, k );
}

/*@
   SpZeroRows - Set the rows of a sparse matrix to zero.

   Input Parameter:
.  mat - matrix
  
   Notes:
   This routine does not recover space; it simply marks each row of the
   matrix as having no elements.
 @*/
void SpZeroRows( mat )
SpMat *mat;
{
SpRowMat *R;
SpVec    **rs;
int      i, n;

SPLITTOMAT(mat);
R = GETROWMAT(mat);
rs= R->rs;
n = mat->rows;
for (i=0; i<n; i++)
    (*rs++)->nz = 0;
mat->nz = 0;    
}

/*
   Insert a value.  It is KNOWN not to exist 
 */
void SpiInsertValue( mat, x, col, value, k )
SpMat  *mat;
SpVec  *x;
int    col, k;
double value;
{
int             nzx = x->nz;
register int    *ix, m, *oi;
register double *px, *op;
double *Px;
int    *Ix;

/* Insert value before the kth */
/* bump up the existing value OR allocate new space */
if (x->maxn <= x->nz) {
    /* get more space and insert */
    SPMallocNV( mat, x->nz + mat->alloc_incr, &Px, &Ix ); CHKERR(0);
    px = Px;
    ix = Ix;
    oi = x->i;
    op = x->v;
    for (m=0; m<k; m++) {
	px[m] = op[m];
	ix[m] = oi[m];
	}
    px[k] = value;
    ix[k] = col;
    for (m=k+1; m<=nzx; m++) {
	px[m] = op[m-1];
	ix[m] = oi[m-1];
	}
    if (x->maxn > 0)
	SPFreeNV(mat,x->maxn,x->v,x->i);
    x->v = px;
    x->i = ix;
    x->maxn = x->nz + mat->alloc_incr;
    }
else {
    /* Space is available in this vector */
    px = x->v + k;
    ix = x->i + k;
    nzx= x->nz - k;
    for (m=nzx; m>0; m--) {
	px[m] = px[m-1];
	ix[m] = ix[m-1];
	}
    px[0] = value;
    ix[0] = col;
    }
x->nz++;
if (mat->nz >= 0) mat->nz++;
}
