/*

*/
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "sparse/util/usparse.h"

#if defined(cray)
#define istdic_   SISTDIC
#define diagscal_ SDIAGSCAL
#elif defined(FORTRANCAPS)
#define istdic_   ISTDIC
#define diagscal_ DIAGSCAL
#elif !defined(FORTRANUNDERSCORE)
#define diagscal_ diagscal
#define istdic_   istdic 
#endif
/*@
   SpICC - Given a symmetric SpMat, returns a new SpMatSplit which 
   is an incomplete Cholesky factorization.
   
   Input Parameters:
.  mat - matrix

   Output Parameters:
.  failout - number of failures
.  alphaout -  alpha

   Returns:
   Incomplete Cholesky factorization
@*/
SpMatSplit *SpICC(mat,failout,alphaout)
SpMat  *mat;
int    *failout;
double *alphaout;
{
  double     *diag, *off, *w1, alpha = -.1;
  int        failures = -1;
  int        *row, *col, i,n = mat->rows, *w2, *w3, ret = 1;
  SpMatSplit *split;
  SpMat      *newmat;

  w1 = (double *) MALLOC(n*sizeof(double)); CHKPTRV(w1,0);
  w2 = (int *)    MALLOC(n*sizeof(int)); CHKPTRV(w2,0);
  w3 = (int *)    MALLOC(n*sizeof(int)); CHKPTRV(w3,0);

  while (ret) {
    alpha += .1;
    failures++;
    /* convert to diag, Aij format */
    SpToDiagonalAijSymmetric(mat,&n, &diag,&off,&row,&col); CHKERRV(1,0);

    /* Diagonal Scale new matrix */
    diagscal_(&n,diag,off,row,col);
    if (alpha > 0.0) {for (i=0; i<n; i++) diag[i] += alpha;}

    /* form incomplete Cholesky factor */
    ret = istdic_(&n,diag,off,row,col,w1,w2,w3);
 
    if (ret) {FREE(diag); FREE(off); FREE(row); FREE(col);}
  }
  *alphaout = alpha;
  *failout = failures;
  FREE(w1); FREE(w2); FREE(w3); 

  /* Jones, Plassmann format store diagonal entries in diag  */
  /* But SpMatSplit form stores inverse of diagonal to save  */
  /* divides in backsolves and forward solves. */
  for ( i=0; i<n; i++ ) diag[i] = 1.0/diag[i];

  newmat = SpFromDiagonalAijSymmetric(n,diag,off,row,col); CHKERRV(1,0);
  FREE(diag); FREE(off); FREE(row); FREE(col);

  split = SpSplitFromMat(newmat); CHKERRV(1,0);
  return split;
}
