#ifndef lint
static char SCCSid[] = "@(#) ./sparse/walk.c 07/23/93";
#endif

#include "tools.h"
#include "spmat.h"
#include "sppriv.h"

/*@
    SpWalk - Walk through all of the entries in a matrix. 

    Input parameters:
.    mat     - matrix to add row to
.    routine - routine to call with each element
.    context - passed to the routine
$              routine( row, value, column, context )
$	       int    row, column;
$	       double value;

    Returns: 
    Error value
 @*/
int SpWalk( mat, routine, context )
SpMat  *mat;
int    (*routine)();
void   *context;
{
int      i, nz, j;
int      *c;
double   *v;

SPLITTOMAT(mat);
for (i=0; i<mat->rows; i++) {
    SpScatterFromRow( mat, i, &nz, &c, &v );
    for (j=0; j<nz; j++) {
	(*routine)( i, v[j], c[j], context );
	}		   
    }
return ERR_NONE;
}

/*@
    SpWalkRow - Walk through all of the entries in a matrix a row at a time.

    Input parameters:
.    mat     - matrix to add row to
.    routine - routine to call with each element:
$              routine( row, nonzeros, values, columns, context )
$ 	       int    row, nonzeros, *columns;
$	       double *values;
.    context - passed to the routine

    Returns: Error value
 @*/
int SpWalkRow( mat, routine, context )
SpMat  *mat;
int    (*routine)();
void   *context;
{
int      i, *c, nz;
double   *v;

SPLITTOMAT(mat);
for (i=0; i<mat->rows; i++) {
    SpScatterFromRow( mat, i, &nz, &c, &v );
    (*routine)( i, nz, v, c, context );
    }
return ERR_NONE;
}

