#ifndef lint
static char SCCSid[] = "@(#) ./system/exitall.c 07/23/93";
#endif

#include <string.h>
#include "tools.h"
#include "system/system.h"
#include <stdio.h>         
#ifndef __MSDOS__

#include <signal.h>          /*I <signal.h> I*/
/* This routine handles signals that usually abort a user's code */
static char *SIGNAME[] = { "Unknown", "HUP", "INT", "QUIT", "ILL",
                           "TRAP",    "ABRT", "EMT", "FPE", "KILL", 
                           "BUS", "SEGV", "SYS", "PIPE", "ALRM",
                           "TERM", "URG", "STOP", "TSTP", "CONT", 
                           "CHLD" }; /* There are others, put we won't 
					report them */
/*ARGSUSED*/
/*@
  SYDefaultHandler - Default signal handler.

  Input Parameters:
. sig   - signal value
. code,scp,addr - see the signal man page
@*/
void SYDefaultHandler( sig, code, scp, addr )
int               sig, code;
struct sigcontext *scp;
char              *addr;
{
static char buf[128];

signal( sig, SIG_DFL );
if (sig >= 0 && sig <= 20) 
    sprintf( buf, "Caught signal %s", SIGNAME[sig] );
else
    strcpy( buf, "Caught signal " );
/* Should SYExit fail to abort for any reason, resignal the error
   with the default handler */
SYExit( buf, sig );
kill( getpid(), sig );
}

/*@
   SYSetDefaultSignals - Set up to catch the usual fatal errors and 
   kill a parallel job.

   Input parameter:
.  routine - routine to call when a signal is received.  This should
             have a form that is compatible with "signal".
@*/
void SYSetDefaultSignals( routine )
void (*routine)();
{
if (routine == 0) routine = SYDefaultHandler;
signal( SIGQUIT, routine );
signal( SIGILL,  routine );
signal( SIGFPE,  routine );
signal( SIGBUS,  routine );
signal( SIGSEGV, routine );
signal( SIGSYS,  routine );
}

#else
void SYSetDefaultSignals( routine )
void (*routine)();
{}
#endif

/* 
   Here are the actual exitall routines.  This allows a parallel version
   to replace the routine with one that exits ALL processes in a 
   parallel process
 */
void SYexitall_default(msg,rc)
char *msg;
int  rc;
{
if (msg) fprintf( stderr, "%s\n", msg );
exit(rc);
}

static void (*SYexitall_routine)() = SYexitall_default;

/*@
    SYexitall - Terminate all processes in an execution (parallel exit).

    Input Parameters:
.   str   - Error message string
.   rc    - return code

    Notes:
    The return code may not be available in some implementations.
@*/
void SYexitall(str,rc)
char *str;
int  rc;
{
if (!SYexitall_routine) exit(rc);
(*SYexitall_routine)(str,rc);
}

/*@
    SYSetExitAll - set the routine to be called by SYexitall (parallel exit)

    Input Parameter:
.   r   - routine.  Should be of the form void r(char *str,int rc)
@*/
void SYSetExitAll(r)
void (*r)();
{
SYexitall_routine = r;
}
