#ifndef lint
static char SCCSid[] = "@(#) ./system/file.c 07/23/93";
#endif

#define MAX_FILE_NAME 1024

#include "tools.h"
#include "system/system.h"
#include <stdio.h>
#include <string.h>
#ifndef __MSDOS__
#include <pwd.h>
#endif
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

extern char *mktemp();
extern char *getcwd();

/* WARNING - some systems don't have stdlib.h */
#if !defined(NOSTDHDR)
#include <stdlib.h>

#if defined(tc2000)
extern char *getenv();
#endif

#else
extern char *getenv();
#endif

#if defined(__MSDOS__)
typedef unsigned short u_short;
#endif
#if defined(intelnx) || defined(__MSDOS__)
typedef u_short uid_t;
typedef u_short gid_t;
#endif

#ifndef __MSDOS__
/*@
   SYGetFullPath - Given a filename, return the fully qualified 
                 file name.

   Input parameters:
.   path     - pathname to qualify
.   fullpath - pointer to buffer to hold full pathname
.   flen     - size of fullpath

@*/
void SYGetFullPath( path, fullpath, flen )
char *path, *fullpath;
int  flen;
{
struct passwd *pwde;
int           ln;

if (path[0] == '/') {
    strncpy( fullpath, path, flen ); 
    return;
    }
SYGetwd( fullpath, flen );
strncat( fullpath,"/",flen - strlen(fullpath) );
if ( path[0] == '.' && path[1] == '/' ) 
strncat( fullpath, path+2, flen - strlen(fullpath) - 1 );
else 
strncat( fullpath, path, flen - strlen(fullpath) - 1 );

/* Remove the various "special" forms (~username/ and ~/) */
if (fullpath[0] == '~') {
    char tmppath[MAX_FILE_NAME];
    if (fullpath[1] == '/') {
	pwde = getpwuid( geteuid() );
	if (!pwde) return;
	strcpy( tmppath, pwde->pw_dir );
	ln = strlen( tmppath );
	if (tmppath[ln-1] != '/') strcat( tmppath+ln-1, "/" );
	strcat( tmppath, fullpath + 2 );
	strncpy( fullpath, tmppath, flen );
	}
    else {
	char *p, *name;

	/* Find username */
	name = fullpath + 1;
	p    = name;
	while (*p && isalnum(*p)) p++;
	*p = 0; p++;
	pwde = getpwnam( name );
	if (!pwde) return;
	
	strcpy( tmppath, pwde->pw_dir );
	ln = strlen( tmppath );
	if (tmppath[ln-1] != '/') strcat( tmppath+ln-1, "/" );
	strcat( tmppath, p );
	strncpy( fullpath, tmppath, flen );
	}
    }
/* We could try to handle things like the removal of .. etc */
}
#else
void SYGetFullPath( path, fullpath, flen )
char *path, *fullpath;
int  flen;
{
strcpy( fullpath, path );
}	
#endif

/*@
   SYGetRelativePath - Given a filename, return the relative path (remove
                 all directory specifiers)

   Input parameters:
.   fullpath  - full pathname
.   path      - pointer to buffer to hold relative pathname
.   flen     - size of path

@*/
void SYGetRelativePath( fullpath, path, flen )
char *path, *fullpath;
int  flen;
{
char  *p;

/* Find last '/' */
p = strrchr( fullpath, '/' );
if (!p) p = fullpath;
else    p++;
strncpy( path, p, flen );
}

#if !defined(__MSDOS__)

/*@
    SYGetUserName - Return the name of the user.

    Input Parameter:
    nlen - length of name
    Output Parameter:
.   name - contains user name.  Must be long enough to hold the name

@*/
void SYGetUserName( name, nlen )
int  nlen;
char *name;
{
struct passwd *pw;

pw = getpwuid( getuid() );
if (!pw) 
    strncpy( name, "Unknown",nlen );
else
    strncpy( name, pw->pw_name,nlen );
}
#else
void SYGetUserName( name, nlen )
int  nlen;
char *name;
{
strncpy( name, "Unknown", nlen );
}
#endif /* !MSDOS */
#if !defined(__MSDOS__) && !defined(intelnx)

/*@
    SYGetHostName - Return the name of the host.

    Input Parameter:
    nlen - length of name
    Output Parameter:
.   name - contains host name.  Must be long enough to hold the name
           This is the fully qualified name, including the domain.

@*/
void SYGetHostName( name, nlen )
int  nlen;
char *name;
{
gethostname(name, nlen);
/* See if this name includes the domain */
if (!strchr(name,'.')) {
    int  l;
    l = strlen(name);
    name[l++] = '.';
    getdomainname( name+l, nlen - l );
    }
}
#else
void SYGetHostName( name, nlen )
int  nlen;
char *name;
{
#if defined(intelnx)
#if defined(inteldelta)
strncpy( name, "IntelDelta", nlen );
#else
strncpy( name, "IntelNX", nlen );
#endif
#else
strncpy( name, "Unknown", nlen );
#endif
}
#endif /* !MSDOS */

#ifndef __MSDOS__
/*+
  SYiTestFile - Test for a file existing with a specified mode.

  Input Parameters:
. fname - name of file
. mode  - mode.  One of 'r', 'w', 'e'
. uid,gid - user and group id to use

  Returns:
  1 if file exists with given mode, 0 otherwise.
+*/
int SYiTestFile( fname, mode, uid, gid )
char  *fname, mode;
uid_t uid;
gid_t gid;
{
int         err;
struct stat statbuf;
int         stmode, rbit, wbit, ebit;

if (!fname) return 0;

/* Check to see if the environment variable is a valid regular FILE */
err = stat( fname, &statbuf );
if (err != 0) return 0;

/* At least the file exists ... */
stmode = statbuf.st_mode;
#if defined(rs6000)
#define S_IFREG _S_IFREG
#endif
/* if (!S_ISREG(stmode)) return 0; */
if (!(S_IFREG & stmode)) return 0;
/* Test for accessible. */
if (statbuf.st_uid == uid) {
    rbit = S_IRUSR;
    wbit = S_IWUSR;
    ebit = S_IXUSR;
    }
else if (statbuf.st_gid == gid) {
    rbit = S_IRGRP;
    wbit = S_IWGRP;
    ebit = S_IXGRP;
    }
else {
    rbit = S_IROTH;
    wbit = S_IWOTH;
    ebit = S_IXOTH;
    }
if (mode == 'r') {
    if ((stmode & rbit)) return 1;
    }
else if (mode == 'w') {
    if ((stmode & wbit)) return 1;
    }
else if (mode == 'e') {
    if ((stmode & ebit)) return 1;
    }
return 0;
}
#else
int SYiTestFile( fname, mode, uid, gid )
char  *fname, mode;
uid_t uid;
gid_t gid;
{
int         err;
struct stat statbuf;
int         stmode, rbit, wbit, ebit;

if (!fname) return 0;

/* Check to see if the environment variable is a valid regular FILE */
err = stat( fname, &statbuf );
if (err != 0) return 0;

/* At least the file exists ... */
stmode = statbuf.st_mode;
if (!(S_IFREG & stmode)) return 0;
/* Test for accessible. */
rbit = S_IREAD;
wbit = S_IWRITE;
ebit = S_IEXEC;
if (mode == 'r') {
    if ((stmode & rbit)) return 1;
    }
else if (mode == 'w') {
    if ((stmode & wbit)) return 1;
    }
else if (mode == 'e') {
    if ((stmode & ebit)) return 1;
    }
return 0;
}
#endif /* MSDOS */
/*@
   SYGetFileFromPath - Find a file from a name and an path string
                              A default may be provided.

   Input Parameters:
.  path - A string containing "directory:directory:..." (without the
	  quotes, of course).
	  As a special case, if the name is a single FILE, that file is
	  used.

.  defname - default name
.  name - file name to use with the directories from env
.  mode - file mode desired (usually 'r' for readable; 'w' for writable and
          'e' for executable are also supported)

   Output Parameter:
.  fname - qualified file name

    Returns:
    1 on success, 0 on failure.
@*/
int SYGetFileFromPath( path, defname, name, fname, mode )
char   *path, *defname, *name, *fname, mode;
{
char   *p, *cdir;
int    ln;
uid_t  uid;
gid_t  gid;
char   trial[MAX_FILE_NAME];
char   *senv, *env;

/* Setup default */
SYGetFullPath(defname,fname,MAX_FILE_NAME);

/* Get the (effective) user and group of the caller */
uid = geteuid();
gid = getegid();

if (path) {

/* Check to see if the path is a valid regular FILE */
if (SYiTestFile( path, mode, uid, gid )) {
    strcpy( fname, path );
    return 1;
    }
    
/* Make a local copy of path and mangle it */
senv = env = (char *)MALLOC( strlen(path) + 1 ); CHKPTRV(senv,0);
strcpy( env, path );
while (env) {
    /* Find next directory in env */
    cdir = env;
    p    = strchr( env, ':' );
    if (p) {
	*p  = 0;
	env = p + 1;
	}
    else
	env = 0;

    /* Form trial file name */
    strcpy( trial, cdir );
    ln = strlen( trial );
    if (trial[ln-1] != '/') 
	trial[ln++] = '/';
	
    strcpy( trial + ln, name );

    if (SYiTestFile( trial, mode, uid, gid )) {
        /* need SYGetFullPath rather then copy in case path has . in it */
	SYGetFullPath( trial,  fname, MAX_FILE_NAME );
	FREE( senv );
	return 1;
	}
    }

FREE( senv );
} /* end of if path */

if (SYiTestFile( fname, mode, uid, gid )) return 1;
else return 0;
}

/*@
   SYGetFileFromEnvironment - Find a file from a name and an environment
                              variable.  A default may be provided.

   Input Parameters:
.  env  - name of environment variable.  The contents of this variable
          should be of the form "directory:directory:..." (without the
	  quotes, of course).
	  As a special case, if the name is a single FILE, that file is
	  used.

.  defname - default name
.  name - file name to use with the directories from env
.  mode - file mode desired (usually 'r' for readable; 'w' for writable and
          'e' for executable are also supported)

   Output Parameter:
.  fname - qualified file name

    Returns:
    1 on success, 0 on failure.
@*/
int SYGetFileFromEnvironment( env, defname, name, fname, mode )
char *env, *defname, *name, *fname, mode;
{
char   *edir;

/* Get the environment values */
edir = getenv( env );

return SYGetFileFromPath( edir, defname, name, fname, mode );
}

/*@
   SYOpenWritableFile - Open a writeable file, given a directory path and
                        a filename.

   Input Parameters:
.  dirpath - The list of directories. The contents of this variable
          should be of the form "directory:directory:..." (without the
	  quotes, of course).
.  defname - default name (unused for now)
.  name - file name to use with the directories from env
.  istmp - if 1, use mktemp to generate a file name.  "name" must be in the 
           correct form for mktemp (six trailing X's).

   Output Parameter:
.  fname - qualified file name

   Returns:
   Pointer to open FILE.
@*/
FILE *SYOpenWritableFile( dirpath, defname, name, fname, istmp )
char *dirpath, *defname, *name, *fname;
int  istmp;
{
char   *p, *cdir;
int    ln;
FILE   *fp;

while (dirpath && *dirpath) {
    /* Find next directory in env */
    cdir = dirpath;
    p    = strchr( dirpath, ':' );
    if (p) {
	dirpath = p + 1;
	}
    else {
	p       = dirpath + strlen(dirpath);
	dirpath = 0;
	}

    /* Form trial file name */
    strncpy( fname, cdir, (int)(p-cdir) );
    fname[(int)(p-cdir)] = 0;
    ln = strlen( fname );
    if (fname[ln-1] != '/') 
	fname[ln++] = '/';
	
    strcpy( fname + ln, name );
    if (istmp) 
	fname = mktemp( fname );

    /* Form full path name */
    /* strcpy( path, fname ); */
    /* SYGetFullPath( path, fname, MAX_FILE_LEN ); */

    /* Is the file accessible? */
    /* fprintf( stderr, "Trying filename %s\n", fname ); */
    fp = fopen( fname, "w" );
    if (fp) return fp;
    }

/* Try the default name */
if (istmp)
    fname = mktemp( fname );
fp = fopen( fname, "w" );

return fp;
}

/*@
  SYGetwd - Get the current working directory

  Input paramters:
. path - use to hold the result value
. len  - maximum length of path
@*/
void SYGetwd( path, len )
char *path;
int  len;
{
#if defined(tc2000) || defined(sun4)
getwd( path );
#else
getcwd( path, len );
#endif
}

#if !defined(__MSDOS__)
#include <sys/param.h>
#endif
#ifndef MAXPATHLEN
/* sys/param.h in intelnx does not include MAXPATHLEN! */
#define MAXPATHLEN 1024
#endif

/*@
   SYGetRealpath - get the path without symbolic links etc

   Input Parameter:
.  path - path to resolve

   Output Parameter:
.  rpath - resolved path

   Note: rpath is assumed to be of length MAXPATHLEN
@*/
char *SYGetRealpath( path, rpath )
char *path, *rpath;
{
#if defined(sun4)
extern char *realpath();
return realpath( path, rpath );

#elif defined(intelnx) || defined(__MSDOS__)
strcpy( rpath, path );
return rpath;

#else
#if defined(IRIX)
extern char *strchr();
#endif
  int  n, m, N;
  char tmp1[MAXPATHLEN], tmp3[MAXPATHLEN], tmp4[MAXPATHLEN], *tmp2;
  strncpy(tmp1,path,MAXPATHLEN);
  N = strlen(tmp1);
  while (N) {
    strncpy(tmp1,path,N); tmp1[N] = 0;
    n = readlink(tmp1,tmp3,MAXPATHLEN);
    if (n > 0) {
      tmp3[n] = 0; /* readlink does not automatically add 0 to string end */
      if (tmp3[0] != '/') {
        tmp2 = strchr(tmp1,'/');
        m = strlen(tmp1) - strlen(tmp2);
        strncpy(tmp4,tmp1,m); tmp4[m] = 0;
        strncat(tmp4,"/",MAXPATHLEN - strlen(tmp4));
        strncat(tmp4,tmp3,MAXPATHLEN - strlen(tmp4));
        SYGetRealpath(tmp4,rpath);
        strncat(rpath,path+N,MAXPATHLEN - strlen(rpath));
        return rpath;
      }
      else {
        SYGetRealpath(tmp3,tmp1);
        strncpy(rpath,tmp1,MAXPATHLEN);
        strncat(rpath,path+N,MAXPATHLEN - strlen(rpath));
        return rpath;
      }
    }  
    tmp2 = strchr(tmp1,'/');
    if (tmp2) N = strlen(tmp1) - strlen(tmp2);
    else N = strlen(tmp1);
  }
  strncpy(rpath,path,MAXPATHLEN);
  return rpath;
#endif
}

#if !defined(__MSDOS__)
/*@
     SYRemoveHomeDir - Given a complete true path, remove user's home directory

   Input Parameter:
.  path - path to be possibly modified

   Note:
   Given a complete path (for instance by SYGetRealpath), if the path begins 
   with the users home directory, the user's home directory is removed.

   This is useful on systems where a users home directory may have
   different names on different machines, or different names each time
   one logs in (such systems exist!).
@*/
void SYRemoveHomeDir( path )
char *path;
{
  struct passwd *pw = 0;
  char          tmp1[MAXPATHLEN], tmp2[MAXPATHLEN], *d1, *d2;
  int           len;

  pw = getpwuid( getuid() );
  if (!pw)  return;
  strcpy(tmp1, pw->pw_dir);
  SYGetRealpath( tmp1, tmp2 );

  /* some have /tmp_mnt; others don't */
  if (!strncmp(path,"/tmp_mnt",8)) d1 = path + 8; else d1 = path;
  if (!strncmp(tmp2,"/tmp_mnt",8)) d2 = tmp2 + 8; else d2 = tmp2;
  if (strncmp(d1,d2,strlen(d2))) return;
  len = strlen(d2) + 1;
  strcpy(tmp1,d1+len); /* we know these will fit */
  strcpy(path,tmp1);
}
#else
void SYRemoveHomeDir( path )
char *path;
{
}
#endif /* MSDOS */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif
/*@
     SYIsMachineHost - returns true if name passed in matches host
                       name else false.
 
  Input Paramters:
.  machinename - Name of the machine to test
 
@*/
int SYIsMachineHost( machinename )
char *machinename;
{
  static char localhost[MAXHOSTNAMELEN];
  static int  hostlength = 0;
  int         namelen;
  char        *tmp;
 
  if (!hostlength) {
    SYGetHostName(localhost,MAXHOSTNAMELEN);
    hostlength = strlen(localhost);
#if !defined(RELIABLEHOSTNAME)
    if (tmp = strchr(localhost,'.')) {
      hostlength = strlen(localhost) - strlen(tmp);
    }
#endif
  }
#if !defined(RELIABLEHOSTNAME)
  /* Only test leading characters of the localname against the leading 
     characters of the host */
  if (tmp = strchr( machinename, '.' )) 
      namelen = strlen( machinename ) - strlen( tmp );
  else
      namelen = strlen( machinename );
  return (namelen == hostlength && !strncmp(machinename,localhost,hostlength));
#else 
  return !strncmp(machinename,localhost,hostlength);
#endif
}

#ifndef S_ISDIR
#define	S_ISDIR(m)	(((m)&S_IFMT) == S_IFDIR)
#endif
/*@
  SYIsDirectory - Tests to see if a filename is a directory.

  Input Parameters:
. fname - name of file

  Returns:
  1 if file is a directory, 0 otherwise
@*/
int SYIsDirectory( fname )
char  *fname;
{
int         err;
struct stat statbuf;
int         stmode;

if (!fname) return 0;

err = stat( fname, &statbuf );
if (err != 0) return 0;

/* At least the file exists ... */
stmode = statbuf.st_mode;
return S_ISDIR(stmode);
}
