/*
   This program tests malloc allocations in an attempt to discover the
   allocation pattern

   Results:
   On the sun4 (4.1.3), there appear to always be 8 bytes between allocated
   elements.
 */
extern char *malloc();
main( argc, argv )
int  argc;
char **argv;
{
char *p1, *p2;
int  bsize, incrment, maxincr, minincr;
int  i, ntest = 100;

bsize = 1024;
SYArgGetInt( &argc, argv, 1, "-size", &bsize );

p1 = malloc( bsize );
p2 = malloc( bsize );
incrment = (int)( p2 - p1 ) - bsize;
maxincr  = minincr = incrment;

for (i=0; i<ntest; i++) {
    p1 = p2;
    p2 = malloc( bsize );
    if (!p2) break;
    incrment = (int)( p2 - p1 ) - bsize;
    if (incrment > maxincr) maxincr = incrment;
    if (incrment < minincr) minincr = incrment;
    }

printf( "For allocations of size %d, spacing between successive blocks is:\n",
        bsize );
printf( "%d to %d\n", minincr, maxincr );
}
    
