#ifndef lint
static char SCCSid[] = "@(#) ./system/system.c 07/23/93";
#endif

#include "tools.h"
#include <stdio.h>

#if !defined(__MSDOS__) && !defined(cray)
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#if defined(solaris)
#include <sys/rusage>
#endif
#ifdef FOO
/*  I've turned this off, since SYGetCPUTime() does the same thing.

    SYSecond - Returns the time in seconds used by the process. */
double SYSecond()
{
#if defined(titan)
  return(1.0e-6*((double) clock()));
#elif defined(intelnx)
  unsigned long mclock();
  return(1.e-3*mclock());
#elif defined(cm5)
static int not_ready = 1;
extern double CMMD_node_timer_busy();
double val;
#define CM5TOOLSTIMER1 1
if (not_ready) {
    CMMD_node_timer_clear( CM5TOOLSTIMER1 );
    CMMD_node_timer_start( CM5TOOLSTIMER1 );
    not_ready = 0;
    }

CMMD_node_timer_stop( CM5TOOLSTIMER1 );
val = CMMD_node_timer_busy( CM5TOOLSTIMER1 );
CMMD_node_timer_start( CM5TOOLSTIMER1 );
return val;
#else
  static struct rusage temp;
  double foo, foo1;

  getrusage(RUSAGE_SELF,&temp);
  foo     = temp.ru_utime.tv_sec;     /* seconds */
  foo1    = temp.ru_utime.tv_usec;    /* uSecs */
  return(foo + foo1 * 1.0e-6);
#endif
} 
#endif

/*@
   SYGetResidentSetSize - Returns the maximum resident set size.
@*/
double SYGetResidentSetSize()
{
#if !defined(intelnx) && !defined(titan)
  static struct rusage temp;
  double foo;
  getrusage(RUSAGE_SELF,&temp);
#ifdef rs6000
  /* RS6000 always reports sizes in k instead of pages */
  foo = 1024.0 * (double) temp.ru_maxrss;
#else
  foo = ( (double) getpagesize())*( (double) temp.ru_maxrss );
#endif
  return(foo);
#else
  return(0.0);
#endif
}
/*@ 
    SYGetPageFaults - This routine returns the number of page faults.                 
     Output Parameters:                                              
.       pnoio    - Number of faults that did not require IO                
.       pio      - Number of faults that did require IO                    
@*/
void SYGetPageFaults( pnoio, pio )
int *pnoio, *pio;
{
#if !defined(intelnx)
  static struct rusage temp;
  getrusage(RUSAGE_SELF,&temp);
  *pnoio  = temp.ru_minflt;
  *pio    = temp.ru_majflt;
#else 
  *pnoio  = 0;
  *pio    = 0;
#endif
}

#else
/* MSDOS routines */
#include <time.h>
double SYSecond()
{
  return (((double) clock())/(double)CLK_TCK);
}
/* ------------------------------------------------------------------*/
/*           Returns the maximum resident set size                   */
/* ------------------------------------------------------------------*/
double SYGetResidentSetSize()
{
return(0.0);
}
/* ------------------------------------------------------------------*/
/*   This routine returns the number of page faults.                 */
/*   Output parameters:                                              */
/*     pnoio    - Number of faults that did not require IO                */
/*     pio      - Number of faults that did require IO                    */
/* ------------------------------------------------------------------*/
void SYGetPageFaults( pnoio, pio )
int *pnoio, *pio;
{
  *pnoio  = 0;
  *pio    = 0;
  return;
}
#endif




