#ifndef lint
static char SCCSid[] = "@(#) ./system/time/elptime.c 07/23/93";
#endif

#include "tools.h"
#include "system/system.h"
#include <stdio.h>

#if !defined(__MSDOS__)
#include <sys/types.h>
#include <sys/time.h>

static struct timeval ELTime = { 0, 0 };
static int            NoBase = 1;

/*@
    SYGetElapsedTime - Returns a the elapsed time since the first call to this
    routine.

    Notes:  In order to get sub-second resolution, the routine gettimeofday
    is used.

    Example:
$   #include "system/system.h"
$   ...
$   double t1, t2;
$
$   t1 = SYGetElapsedTime();
$   ... code to time ...
$   t2 = SYGetElapsedTime() - t1;
$   printf( "Code took %f wall-clock seconds\n", t2 );
$

@*/
double SYGetElapsedTime()
{
struct timeval tp;

SYGetDayTime( &tp );
if (NoBase) {
    ELTime.tv_sec  = tp.tv_sec;
    ELTime.tv_usec = tp.tv_usec;
    NoBase = 0;
    return 0.0;
    }
return (double)(tp.tv_sec - ELTime.tv_sec) + 
       (1.0e-6)*(tp.tv_usec - ELTime.tv_usec);
}
#endif
