#ifndef lint
static char SCCSid[] = "@(#) ./xtools/solid/tran.c 07/23/93";
#endif

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/base3d.h"

/* @
  XB3dTranVert - transfrom from the world system to the viewport system
                  perform clipping on view volume(???)

  Note: sets the DISPLAY coords in the vertex structure.  We may want to
  do some of the intermediate computations in double rather than int.

  Care should be exersized in defining the matrix entries.  For example,
  since 
@ */
void XB3dTranVert( v, Trans )
XBVertices *v;
XBTrans3d  *Trans;
{
int      k, nv;
double   *mat, *permat, sum, d;
double   cx, cy, cz;
XBxyz    *vx;
XBTxyz   *wvx;
int      xoff = Trans->xoff, yoff = Trans->yoff;

nv     = v->nv;
mat    = Trans->mat;
permat = Trans->permat;
vx     = v->xyz;
wvx    = v->txyz;
for (k=0; k<nv; k++) {
    cx        = XBVX(vx);
    cy        = XBVY(vx);
    cz        = XBVZ(vx);
    sum       = cx * mat[0] + cy * mat[1] + cz * mat[2] + mat[3];
    XBTX(wvx) = sum * permat[0];
    sum       = cx * mat[4] + cy * mat[5] + cz * mat[6] + mat[7];
    XBTY(wvx) = sum * permat[5];
    sum       = cx * mat[8] + cy * mat[9] + cz * mat[10] + mat[11];
    XBTX(wvx) += sum * permat[2];
    XBTY(wvx) += sum * permat[6];
    XBTZ(wvx) = sum * permat[10];
    d         = sum * permat[14];
    /* Mat has only 1 entry in the 4th column; 
       permat only 2 entries in 4th row */
    sum       = mat[15];
    XBTX(wvx) += sum * permat[3];
    XBTY(wvx) += sum * permat[7];
     
    XBTX(wvx) = xoff + XBTX(wvx) / d;
    XBTY(wvx) = yoff + XBTY(wvx) / d;
    /* We don't want to scale wz since this moves z only the image plane */
    /* wvx[2]    /= d */

    vx  ++;
    wvx ++;
    }
}

/* @
   Adjust Trans so that [0,1] x [0,1] is mapped into [x,x+w] x [y,y+h]
@ */
void XB3dScaleTransform( x, y, w, h, Trans )
int       x, y, w, h;
XBTrans3d *Trans;
{
double *permat = Trans->permat;    

permat[0] *= w;
permat[5] *= -h;

/* Adjust for x,y not done yet */
Trans->xoff = x;
Trans->yoff = y;
/*
if (x != 0.0 || y != 0.0) 
    SETERRC(1,"[x,y] != [0,0] unsupported in XB3dScaleTransform");
 */
}


/* @
@ */
XBTrans3d *XB3dCreateTransform( )
{
XBTrans3d *n;

n       = NEW(XBTrans3d);  CHKPTRN(n);

n->xoff = 0;
n->yoff = 0;
return n;
}

